% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{list_md_user_tokens}
\alias{list_md_user_tokens}
\title{List a MotherDuck user's tokens}
\usage{
list_md_user_tokens(user_name, motherduck_token = "MOTHERDUCK_TOKEN")
}
\arguments{
\item{user_name}{A character string specifying the MotherDuck user name whose
tokens should be listed.}

\item{motherduck_token}{Character. Either the name of an environment variable containing your
MotherDuck access token (default \code{"MOTHERDUCK_TOKEN"}) or the token itself.}
}
\value{
A tibble with two columns:
\itemize{
\item \code{token_settings}: metadata fields associated with each token.
\item \code{token_values}: corresponding values for those fields.
}
}
\description{
Retrieves all active authentication tokens associated with a specific
MotherDuck user account, returning them as a tidy tibble.
}
\details{
This function queries the MotherDuck REST API endpoint
\verb{https://api.motherduck.com/v1/users/\{user_name\}/tokens} to list the tokens
available for the specified user.

It uses the provided or environment-resolved \code{motherduck_token} for
authorization. If \code{motherduck_token} is not explicitly provided, the function
attempts to resolve it from the \code{MOTHERDUCK_TOKEN} environment variable
The current authenticated user is displayed via \code{\link[=show_current_user]{show_current_user()}} for
verification.
}
\examples{
\dontrun{
# List tokens for a specific user
tokens_tbl <- list_md_user_tokens(user_name = "alejandro_hagan")
print(tokens_tbl)
}

}
\seealso{
Other db-api: 
\code{\link{configure_md_user_settings}()},
\code{\link{create_md_access_token}()},
\code{\link{create_md_user}()},
\code{\link{delete_md_access_token}()},
\code{\link{delete_md_user}()},
\code{\link{list_md_active_accounts}()},
\code{\link{list_md_user_instance}()},
\code{\link{show_current_user}()}
}
\concept{db-api}
