% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns-checkbox.R
\name{ns_alter_checkbox}
\alias{ns_alter_checkbox}
\title{Alter checkbox matrix variables in a dataset}
\usage{
ns_alter_checkbox(data, to = c("character", "list"), sep = ",", cb = NULL)
}
\arguments{
\item{data}{A `data.frame` containing the
dataset to modify.}

\item{to}{A character string specifying
the output format for checkbox matrix
variables. Must be one of "character" or "list".}

\item{sep}{A character string used as a separator
when `to = "character"`. Defaults to `","`.}

\item{cb}{An optional codebook (`data.frame`) to
identify checkbox matrix variables. If `NULL`,
the codebook is generated using `ns_get_codebook()`.}
}
\value{
A modified `data.frame` with processed
    checkbox matrix variables.
}
\description{
This function processes checkbox matrix
variables in a dataset, transforming their
representations into one of the specified formats.
}
\examples{
\dontshow{
vcr::insert_example_cassette("ns_alter_checkbox", package = "nettskjemar")
nettskjemar:::mock_if_no_auth()
}
dt <- ns_get_data(123823)
cb <- ns_get_codebook(123823)
ns_alter_checkbox(dt, to = "list", cb = cb)
ns_alter_checkbox(dt, to = "character", sep = ";", cb = cb)
\dontshow{
vcr::eject_cassette()
}
}
