% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertLogLin.R
\name{convertLogLin}
\alias{convertLogLin}
\title{Converts a linear effect to a log-linear effect}
\usage{
convertLogLin(ui, ek = c("Ik", "Ek"), cc = c("Ce", "Cc"))
}
\arguments{
\item{ui}{rxode2 model}

\item{ek}{simulation linear constant}

\item{cc}{the concentration value}
}
\value{
model converted from linear to log-linear effect
}
\description{
Converts a linear effect to a log-linear effect
}
\examples{

readModelDb("PK_2cmt_no_depot") |>
  addDirectLin() |>
  convertLogLin()

readModelDb("PK_2cmt_no_depot") |>
  addIndirectLin(stim="out") |>
  convertLogLin()
}
\seealso{
Other PD: 
\code{\link{addBaseline1exp}()},
\code{\link{addBaselineConst}()},
\code{\link{addBaselineExp}()},
\code{\link{addBaselineLin}()},
\code{\link{addDirectLin}()},
\code{\link{convertEmax}()},
\code{\link{convertQuad}()}
}
\author{
Matthew L. Fidler
}
\concept{PD}
