test_that("overall passes", {
  result <- Agresti_simple_diagonals_parameter_quasi_symmetry(vision_data)
  expect_true(abs(7.27 - result$chisq) <= 0.005, info=paste(7.27, result$chisq))
  expect_equal(5, result$df)
  beta <- result$beta
  expect_true(abs(0.054 - beta) <= 0.005, info=paste(0.054, beta))
  se <- result$sigma_beta
  expect_true(abs(0.016 - se) <= 0.005, info=paste(0.016, se))

  expected <- matrix(c(0.0, 263.4, 133.4, 59.1,
                       236.6, 0.0, 418.2, 88.5,
                       107.6, 375.8, 0.0, 202.3,
                       42.9, 71.5, 181.7, 0.0), nrow=4, byrow=TRUE)
  actual <- result$expected
  for (i in 1:4) {
    for (j in 1:4) {
      if (j == i) {
        next
      }
      expect_true(abs(expected[i, j] - actual[i, j]) <= 0.05,
                  info=paste(i, j, expected[i, j], actual[i, j]))
    }
  }
}
)


test_that("results for vision data match", {
  n <- vision_data
  x <- Agresti_create_design_matrix(nrow(n))

  result <- log_linear_fit(n, x)
  expect_true(abs(7.27 - result$chisq) <= 0.005, info=paste(7.27, result$chisq))
  expect_equal(5, result$df)
  beta <- result$beta[length(result$beta)]
  expect_true(abs(0.054 - beta) <= 0.005, info=paste(0.054, beta))
  se <- result$se[length(result$se)]
  expect_true(abs(0.016 - se) <= 0.005, info=paste(0.016, se))

  expected <- matrix(c(0.0, 263.4, 133.4, 59.1,
                       236.6, 0.0, 418.2, 88.5,
                       107.6, 375.8, 0.0, 202.3,
                       42.9, 71.5, 181.7, 0.0), nrow=4, byrow=TRUE)
  actual <- result$expected
  for (i in 1:4) {
    for (j in 1:4) {
      if (j == i) {
        next
      }
      expect_true(abs(expected[i, j] - actual[i, j]) <= 0.05,
                  info=paste(i, j, expected[i, j], actual[j, i]))
    }
  }
}
)

test_that("results for esophogeal cancer data match", {
  n <- esophageal_cancer
  x <- Agresti_create_design_matrix(nrow(n))
  # results are phrase in terms of case, which is swapping rows and columns
  x[,11] <- -x[,11]

  result <- log_linear_fit(n, x)
  expect_true(abs(2.41 - result$chisq) <= 0.005)
  expect_equal(5, result$df)
  beta <- result$beta[length(result$beta)]
  expect_true(abs(0.723 - 2.0 * beta) <= 0.005, info=paste(0.723, 2 * beta))
  se <- result$se[length(result$se)]
  expect_true(abs(0.215 - 2.0 * se) <= 0.005)

  expected <- matrix(c(0.0, 5.6, 3.6, 0.6,
                       11.4, 0.0, 0.3, 0.2,
                       15.4, 0.7, 0.0, 0.7,
                       5.4, 0.8, 1.3, 0.0), nrow=4, byrow=TRUE)
  actual <- result$expected
  for (i in 1:4) {
    for (j in 1:4) {
      if (j == i) {
        next
      }
      expect_true(abs(expected[i, j] - actual[i, j]) <= 0.05)
    }
  }
}
)

test_that("get delta returns right quantity", {
  n <- esophageal_cancer
  x <- Agresti_create_design_matrix(nrow(n))
  # results are phrased in terms of case, which is swapping rows and columns
  x[,11] <- -x[,11]

  result <- log_linear_fit(n, x)
  delta_values <- Agresti_extract_delta(result)
  expect_true(abs(0.723 - 2.0 * delta_values$beta) <= 0.0005)
  expect_true(abs(0.215 - 2.0 * delta_values$sigma_beta) <= 0.0005,
              info=paste(0.215, 2.0* delta_values$sigma_beta), abs(0.215 - 2.0*delta_values$sigma_beta))
  expect_true(abs(0.723 / 0.215 - delta_values$z) <= 0.01,
              info=paste(0.723/0.215, delta_values$z))
  expect_true(abs(2.06 - delta_values$delta) <= 0.005, info=paste(2.06, delta_values$delta))
}
)
