\name{mrg}
\alias{mrg}
\alias{mrg.character}
\alias{mrg.incidence}

\title{
Merge posets
}
\description{
The function merges posets defined through a list of incidence matrices or a list of complete orders between the variables (argument \code{lst}). In the second case the variables must be defined (argument \code{varmod} or \code{varlen}).
}
\usage{
mrg(
    lst,
    varmod = lapply(as.list(varlen), function(x) 1:x),
    varlen = sapply(varmod, length)
)
\method{mrg}{incidence}(lst, varmod = NULL, varlen = NULL)
\method{mrg}{character}(
lst,
    varmod = lapply(as.list(varlen), function(x) 1:x),
    varlen = sapply(varmod, length)
)
}

\arguments{
  \item{lst}{
a list of incidence matrices (class \code{incidence}) or list of vectors of \code{characters}. See details.
}
  \item{varmod}{
list of variables and their grades. See details. 
}
  \item{varlen}{
a vector of number of grades of each variable. See details.
}
}
\details{
For efficiency reasons, the argument \code{lst} can be also a list of vectors of characters. In this case, each vector lists the names of the variables in increasing order.

The list \code{varmod} and the vector \code{varlen} must be named, so as to identify the variables they refer to. The profiles are generated by the combinations of the variables grades. The names of the profiles are the grades of the variables concatenated, according to variables order in \code{varmod}/\code{varlen}. See \code{\link{var2prof}} for more details about these arguments.
}
\value{
an object of S3 class \code{incidence}.
}
\author{
Alberto Arcagni
}
\seealso{
\code{\link{var2prof}}, \code{\link{LE2incidence}}
}
\examples{
# Example with lst as list of incidence matrices
Lambda <- getlambda(A < B, C < D)
plot(Lambda)
lst <- LE(Lambda)
vl <- c(A = 2, B = 2, C = 2, D = 2)
lstZeta <- LE2incidence(lst, varlen = vl)
for (x in lstZeta)
    plot(x)
mrg(lstZeta)

# Example with lst as list of characters
Lambda <- getlambda(A < B, C < D)
lst <- LE(Lambda)
vl <- c(A = 2, B = 2, C = 2, D = 2)
Zeta <- mrg(lst, varlen = vl)
plot(Zeta)
}
