# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

Mid_w <- function(A, B, w, metric) {
    .Call(`_pdSpecEst_Mid_w`, A, B, w, metric)
}

pdMean_C_approx <- function(M, mu) {
    .Call(`_pdSpecEst_pdMean_C_approx`, M, mu)
}

pdMean_C <- function(M0, M, mu, maxit, reltol) {
    .Call(`_pdSpecEst_pdMean_C`, M0, M, mu, maxit, reltol)
}

pdMedian_C <- function(M0, M, mu, maxit, reltol) {
    .Call(`_pdSpecEst_pdMedian_C`, M0, M, mu, maxit, reltol)
}

Euclid_Median_C <- function(M0, M, mu, maxit, reltol) {
    .Call(`_pdSpecEst_Euclid_Median_C`, M0, M, mu, maxit, reltol)
}

pdNeville_C <- function(P, X, x, metric) {
    .Call(`_pdSpecEst_pdNeville_C`, P, X, x, metric)
}

impute_C <- function(M0, W, L, inverse, metric, method) {
    .Call(`_pdSpecEst_impute_C`, M0, W, L, inverse, metric, method)
}

wavPyr2D_C <- function(P, n1, n2, metric) {
    .Call(`_pdSpecEst_wavPyr2D_C`, P, n1, n2, metric)
}

impute2D_C <- function(M0, W, n1, n2, L, metric, method) {
    .Call(`_pdSpecEst_impute2D_C`, M0, W, n1, n2, L, metric, method)
}

pdDist_C <- function(A, B, metric) {
    .Call(`_pdSpecEst_pdDist_C`, A, B, metric)
}

gdd_C <- function(X, y, metric, S, method) {
    .Call(`_pdSpecEst_gdd_C`, X, y, metric, S, method)
}

cMeans_C <- function(M, centroids, S, K, m, eps, max_iter, metric, dist_weights) {
    .Call(`_pdSpecEst_cMeans_C`, M, centroids, S, K, m, eps, max_iter, metric, dist_weights)
}

#' Geodesic midpoint between HPD matrices
#'
#' \code{Mid} calculates the geodesic midpoint between two HPD matrices under the
#' affine-invariant Riemannian metric as in \insertCite{B09}{pdSpecEst}[Chapter 6].
#'
#' @param A,B Hermitian positive definite matrices (of equal dimension).
#'
#' @examples
#'  ## Generate two random HPD matrices
#'  a <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
#'  A <- t(Conj(a)) %*% a
#'  b <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
#'  B <- t(Conj(b)) %*% b
#'  ## Compute midpoint
#'  Mid(A, B)
#'  ## Midpoint coincides with two-point intrinsic Karcher mean
#'  all.equal(pdMean(array(c(A, B), dim = c(3, 3, 2))), Mid(A, B))
#'
#' @references
#' \insertAllCited{}
#'
#' @seealso \code{\link{pdMean}}
#'
#' @export
Mid <- function(A, B) {
    .Call(`_pdSpecEst_Mid`, A, B)
}

Sqrt <- function(M) {
    .Call(`_pdSpecEst_Sqrt`, M)
}

Chol_C <- function(M, bias, inverse) {
    .Call(`_pdSpecEst_Chol_C`, M, bias, inverse)
}

iSqrt <- function(M) {
    .Call(`_pdSpecEst_iSqrt`, M)
}

NormF <- function(M) {
    .Call(`_pdSpecEst_NormF`, M)
}

wavPyr_C <- function(P, L, J, Nj, metric) {
    .Call(`_pdSpecEst_wavPyr_C`, P, L, J, Nj, metric)
}

wavCoeff_C <- function(M1, M0, j, metric) {
    .Call(`_pdSpecEst_wavCoeff_C`, M1, M0, j, metric)
}

reconstr_C <- function(M1, M0, Dj, j, nj, in_sample, L1, metric) {
    .Call(`_pdSpecEst_reconstr_C`, M1, M0, Dj, j, nj, in_sample, L1, metric)
}

reconstr2D_C <- function(M1, D, j, n, in_sample, metric) {
    .Call(`_pdSpecEst_reconstr2D_C`, M1, D, j, n, in_sample, metric)
}

Ptransf2D_C <- function(P, inverse, chol_bias, metric) {
    .Call(`_pdSpecEst_Ptransf2D_C`, P, inverse, chol_bias, metric)
}

#' Riemannian HPD exponential map
#'
#' \code{Expm(P, H)} computes the projection of a Hermitian matrix \code{H} from the tangent space at a Hermitian
#' PD matrix \code{P} to the manifold of Hermitian PD matrices equipped with the affine-invariant Riemannian metric
#' via the exponential map as in e.g., \insertCite{PFA05}{pdSpecEst}. This is the unique inverse of the Riemannian
#' logarithmic map \code{\link{Logm}}.
#'
#' @param P a Hermitian positive definite matrix.
#' @param H a Hermitian matrix (of equal dimension as \code{P}).
#'
#' @examples
#'  ## Generate random Hermitian matrix
#'  H <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
#'  diag(H) <- rnorm(3)
#'  H[lower.tri(H)] <- t(Conj(H))[lower.tri(H)]
#'  ## Generate random HPD matrix
#'  p <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
#'  P <- t(Conj(p)) %*% p
#'  ## Compute exponential map
#'  Expm(P, H)
#'
#' @references
#' \insertAllCited{}
#'
#' @seealso \code{\link{Logm}, \link{pdParTrans}}
#'
#' @export
Expm <- function(P, H) {
    .Call(`_pdSpecEst_Expm`, P, H)
}

#' Riemannian HPD logarithmic map
#'
#' \code{Logm(P, Q)} computes the projection of a Hermitian PD matrix \code{Q} in the manifold of HPD matrices
#' equipped with the affine-invariant Riemannian metric to the tangent space attached at the Hermitian PD matrix
#' \code{P} via the logarithmic map as in e.g., \insertCite{PFA05}{pdSpecEst}. This is the unique inverse of
#' the exponential map \code{\link{Expm}}.
#'
#' @param P a Hermitian positive definite matrix.
#' @param Q a Hermitian positive definite matrix (of equal dimension as \code{P}).
#'
#' @examples
#'  ## Generate two random HPD matrices
#'  q <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
#'  Q <- t(Conj(q)) %*% q
#'  p <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
#'  P <- t(Conj(p)) %*% p
#'  ## Compute logarithmic map
#'  Logm(P, Q)
#'
#' @references
#' Pennec, X. (2006). Intrinsic statistics on Riemannian manifolds: Basic tools for geometric
#' measurements. \emph{Journal of Mathematical Imaging and Vision} 25(1), 127-154.
#'
#' @seealso \code{\link{Expm}, \link{pdParTrans}}
#'
#' @export
Logm <- function(P, Q) {
    .Call(`_pdSpecEst_Logm`, P, Q)
}

#' Riemannian HPD parallel transport
#'
#' \code{pdParTrans} computes the parallel transport on the manifold of HPD matrices
#' equipped with the affine-invariant Riemannian metric as described in e.g., Chapter 2 of \insertCite{C18}{pdSpecEst}. That is,
#' the function computes the parallel transport of a Hermitian matrix \code{W} in the tangent space
#' at the HPD matrix \code{P} along a geodesic curve in the direction of the Hermitian matrix \code{V}
#' in the tangent space at \code{P} for a unit time step.
#'
#' @param P a \eqn{(d,d)}-dimensional HPD matrix.
#' @param V a \eqn{(d,d)}-dimensional Hermitian matrix corresponding to a vector in the tangent space of \code{P}.
#' @param W a \eqn{(d,d)}-dimensional Hermitian matrix corresponding to a vector in the tangent space of \code{P}.
#'
#' @return a \eqn{(d,d)}-dimensional Hermitian matrix corresponding to the parallel transportation of \code{W} in
#' the direction of \code{V} along a geodesic curve for a unit time step.
#'
#' @examples
#' ## Transport the vector W to the tangent space at the identity
#' W <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
#' diag(W) <- rnorm(3)
#' W[lower.tri(W)] <- t(Conj(W))[lower.tri(W)]
#' p <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
#' P <- t(Conj(p)) %*% p
#'
#' pdParTrans(P, Logm(P, diag(3)), W) ## whitening transport
#'
#' @references
#' \insertAllCited{}
#'
#' @seealso \code{\link{Expm}, \link{Logm}}
#'
#' @export
pdParTrans <- function(P, V, W) {
    .Call(`_pdSpecEst_pdParTrans`, P, V, W)
}

E_coeff <- function(H) {
    .Call(`_pdSpecEst_E_coeff`, H)
}

T_coeff <- function(H, y) {
    .Call(`_pdSpecEst_T_coeff`, H, y)
}

E_coeff_inv <- function(coeff) {
    .Call(`_pdSpecEst_E_coeff_inv`, coeff)
}

T_coeff_inv <- function(coeff, y) {
    .Call(`_pdSpecEst_T_coeff_inv`, coeff, y)
}

ARMA <- function(Phi, Theta, Z, len) {
    .Call(`_pdSpecEst_ARMA`, Phi, Theta, Z, len)
}

pgram_C <- function(X, B, h, method, is_2D) {
    .Call(`_pdSpecEst_pgram_C`, X, B, h, method, is_2D)
}

