% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advs_metabolic.R
\docType{data}
\name{advs_metabolic}
\alias{advs_metabolic}
\title{Vital Signs Analysis for Metabolic}
\format{
A data frame with 101 columns:
\describe{
\item{ STUDYID }{Study Identifier}
\item{ DOMAIN }{Domain Abbreviation}
\item{ USUBJID }{Unique Subject Identifier}
\item{ VSSEQ }{Sequence Number}
\item{ VSTESTCD }{Vital Signs Test Short Name}
\item{ VSTEST }{Vital Signs Test Name}
\item{ VSPOS }{Vital Signs Position of Subject}
\item{ VSORRES }{Result or Finding in Original Units}
\item{ VSORRESU }{Original Units}
\item{ VSSTRESC }{Character Result/Finding in Std Format}
\item{ VSSTRESN }{Numeric Result/Finding in Standard Units}
\item{ VSSTRESU }{Standard Units}
\item{ VSSTAT }{Completion Status}
\item{ VSLOC }{Location of Vital Signs Measurement}
\item{ VSBLFL }{Baseline Flag}
\item{ VISITNUM }{Visit Number}
\item{ VISIT }{Visit Name}
\item{ VISITDY }{Planned Study Day of Visit}
\item{ VSDTC }{Date/Time of Measurements}
\item{ VSDY }{Study Day of Vital Signs}
\item{ VSTPT }{Planned Time Point Name}
\item{ VSTPTNUM }{Planned Time Point Number}
\item{ VSELTM }{Planned Elapsed Time from Time Point Ref}
\item{ VSTPTREF }{Time Point Reference}
\item{ TRTSDT }{Date of First Exposure to Treatment}
\item{ TRTEDT }{Date of Last Exposure to Treatment}
\item{ TRT01P }{Planned Treatment for Period 01}
\item{ TRT01A }{Actual Treatment for Period 01}
\item{ PARAMCD }{Parameter Code}
\item{ ADT }{Analysis Date}
\item{ ADY }{Analysis Relative Day}
\item{ ATPT }{Analysis Timepoint}
\item{ ATPTN }{Analysis Timepoint (N)}
\item{ AVISIT }{Analysis Visit}
\item{ AVISITN }{Analysis Visit (N)}
\item{ AVAL }{Analysis Value}
\item{ AVALCAT1 }{Analysis Value Category 1}
\item{ AVALCA1N }{Analysis Value Category 1 (N)}
\item{ ABLFL }{Baseline Record Flag}
\item{ BASE }{Baseline Value}
\item{ CHG }{Change from Baseline}
\item{ PCHG }{Percent Change from Baseline}
\item{ BASECAT1 }{Baseline Category 1}
\item{ BASECA1N }{Baseline Category 1 (N)}
\item{ CRIT1FL }{Criterion 1 Evaluation Result Flag}
\item{ CRIT1 }{Analysis Criterion 1}
\item{ CRIT2FL }{Criterion 2 Evaluation Result Flag}
\item{ CRIT2 }{Analysis Criterion 2}
\item{ PARAM }{Parameter}
\item{ PARAMN }{Parameter (N)}
\item{ PARCAT1 }{Parameter Category 1}
\item{ PARCAT1N }{Parameter Category 1 (N)}
\item{ SUBJID }{Subject Identifier for the Study}
\item{ RFSTDTC }{Subject Reference Start Date/Time}
\item{ RFENDTC }{Subject Reference End Date/Time}
\item{ RFXSTDTC }{Date/Time of First Study Treatment}
\item{ RFXENDTC }{Date/Time of Last Study Treatment}
\item{ RFICDTC }{Date/Time of Informed Consent}
\item{ RFPENDTC }{Date/Time of End of Participation}
\item{ DTHDTC }{Date/Time of Death}
\item{ DTHFL }{Subject Death Flag}
\item{ SITEID }{Study Site Identifier}
\item{ AGE }{Age}
\item{ AGEU }{Age Units}
\item{ SEX }{Sex}
\item{ RACE }{Race}
\item{ ETHNIC }{Ethnicity}
\item{ ARMCD }{Planned Arm Code}
\item{ ARM }{Description of Planned Arm}
\item{ ACTARMCD }{Actual Arm Code}
\item{ ACTARM }{Description of Actual Arm}
\item{ COUNTRY }{Country}
\item{ DMDTC }{Date/Time of Collection}
\item{ DMDY }{Study Day of Collection}
\item{ TRTSDTM }{Datetime of First Exposure to Treatment}
\item{ TRTSTMF }{Time of First Exposure Imput. Flag}
\item{ TRTEDTM }{Datetime of Last Exposure to Treatment}
\item{ TRTETMF }{Time of Last Exposure Imput. Flag}
\item{ TRTDURD }{Total Treatment Duration (Days)}
\item{ SCRFDT }{Screen Failure Date}
\item{ EOSDT }{End of Study Date}
\item{ EOSSTT }{End of Study Status}
\item{ FRVDT }{Final Retrieval Visit Date}
\item{ RANDDT }{Date of Randomization}
\item{ DTHDT }{Date of Death}
\item{ DTHDTF }{Date of Death Imputation Flag}
\item{ DTHADY }{Relative Day of Death}
\item{ LDDTHELD }{Elapsed Days from Last Dose to Death}
\item{ DTHCAUS }{Cause of Death}
\item{ DTHDOM }{Domain for Date of Death Collection}
\item{ DTHCGR1 }{Cause of Death Reason 1}
\item{ LSTALVDT }{Date Last Known Alive}
\item{ SAFFL }{Safety Population Flag}
\item{ RACEGR1 }{Pooled Race Group 1}
\item{ AGEGR1 }{Pooled Age Group 1}
\item{ REGION1 }{Geographic Region 1}
\item{ LDDTHGR1 }{Last Dose to Death - Days Elapsed Grp 1}
\item{ DTH30FL }{Death Within 30 Days of Last Trt Flag}
\item{ DTHA30FL }{Death After 30 Days from Last Trt Flag}
\item{ DTHB30FL }{Death Within 30 Days of First Trt Flag}
\item{ ASEQ }{Analysis Sequence Number}
}
}
\source{
Generated from admiralmetabolic package (template ad_advs.R).
}
\usage{
advs_metabolic
}
\description{
Vital Signs Analysis for Metabolic
}
\details{
Contains a set of 10 unique Parameter Codes and Parameters: \tabular{ll}{
\strong{PARAMCD} \tab \strong{PARAM} \cr
BMI      \tab Body Mass Index (kg/m2)        \cr
DIABP    \tab Diastolic Blood Pressure (mmHg)\cr
HEIGHT   \tab Height (cm)                    \cr
HIPCIR   \tab Hip Circumference (cm)         \cr
PULSE    \tab Pulse Rate (beats/min)         \cr
SYSBP    \tab Systolic Blood Pressure (mmHg) \cr
TEMP     \tab Temperature (C)                \cr
WAISTHIP \tab Waist to Hip Ratio             \cr
WEIGHT   \tab Weight (kg)                    \cr
WSTCIR   \tab Waist Circumference (cm)
}
}
\examples{
data("advs_metabolic")
}
\references{
None
}
\keyword{datasets}
