% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.solar.spectra.data.r
\docType{data}
\name{sun_elevation.spct}
\alias{sun_elevation.spct}
\title{Ground level spectral irradiance and sun elevation}
\format{
A \code{source_spct} containing 34 spectra in long form (290.5 nm to
  699.5 nm at 1 nm interval) and 6 variables.
}
\usage{
sun_elevation.spct
}
\description{
Datasets containing the wavelengths at 1.0 nm interval and tabulated values
of spectral irradiance and its direct and diffuse components at different 
sun elevation angles under clear sky conditions.
}
\details{
The variables are as follows: 
\itemize{ 
\item w.length numeric (nm) 
\item s.e.irrad numeric (W m-2 nm-1) 
\item s.e.irrad.dir numeric (W m-2 nm-1)
\item s.e.irrad.diff.down numeric (W m-2 nm-1)
\item s.e.irrad.diff.up numeric (W m-2 nm-1)
\item sun.elevation factor with one level per spectrum
}
}
\examples{
e_irrad(sun_elevation.spct)
wl_range(sun_elevation.spct)
getMultipleWl(sun_elevation.spct) # number of spectra

}
\references{
Quick TUV calculator 
\url{https://www.acom.ucar.edu/Models/TUV/Interactive_TUV/}.
}
\author{
Pedro J. Aphalo (radiation transfer modelling with Quick TUV 
calculator, TUV 5.3)
}
\keyword{datasets}
