#' @title Data for typical calibration lamps
#'
#' @description A dataset containing fitted constants to be used as input for
#'   functions \code{\link{D2_spectrum}} and \code{\link{FEL_spectrum}} for
#'   computing example spectral curves based on fitted polynomials.
#'
#' @details An object of class \code{polynom::polynomial}.
#'
#' @author Lasse Ylianttila (data)
#'
#' @docType data
#' @keywords datasets
#' @format A \code{polynom::polynomial} object with 6 constants.
#'
#' @examples
#' D2.UV653
#' as.character(D2.UV653)
#'
#' @name D2.UV653
NULL

#' @rdname D2.UV653
#' @name D2.UV586
NULL

#' @rdname D2.UV653
#' @name D2.UV654
NULL

#' @rdname D2.UV653
#' @name FEL.BN.9101.165
NULL
