% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcr.cv.R
\name{pcr.cv}
\alias{pcr.cv}
\title{Model selection for Princinpal Components regression based on
cross-validation}
\usage{
pcr.cv(
  X,
  y,
  k = 10,
  m = min(ncol(X), nrow(X) - 1),
  groups = NULL,
  scale = TRUE,
  eps = 1e-06,
  plot.it = FALSE,
  compute.jackknife = TRUE,
  method.cor = "pearson",
  supervised = FALSE
)
}
\arguments{
\item{X}{matrix of predictor observations.}

\item{y}{vector of response observations. The length of \code{y} is the same
as the number of rows of \code{X}.}

\item{k}{number of cross-validation splits. Default is 10.}

\item{m}{maximal number of principal components. Default is
\code{m=min(ncol(X),nrow(X)-1)}.}

\item{groups}{an optional vector with the same length as \code{y}. It
encodes a partitioning of the data into distinct subgroups. If \code{groups}
is provided, \code{k=10} is ignored and instead, cross-validation is
performed based on the partioning. Default is \code{NULL}.}

\item{scale}{Should the predictor variables be scaled to unit variance?
Default is \code{TRUE}.}

\item{eps}{precision. Eigenvalues of the correlation matrix of \code{X} that
are smaller than \code{eps} are set to 0. The default value is
\code{eps=10^{-6}.}}

\item{plot.it}{Logical. If \code{TRUE}, the function plots the
cross-validation-error as a function of the number of components. Default is
\code{FALSE}.}

\item{compute.jackknife}{Logical. If \code{TRUE}, the regression
coefficients on each of the cross-validation splits is stored. Default is
\code{TRUE}.}

\item{method.cor}{How should the correlation to the response be computed?
Default is ''pearson''.}

\item{supervised}{Should the principal components be sorted by decreasing
squared correlation to the response? Default is FALSE.}
}
\value{
\item{cv.error.matrix}{matrix of cross-validated errors based on
mean squared error. A row corresponds to one cross-validation split.}
\item{cv.error}{vector of cross-validated errors based on mean squared
error} \item{m.opt}{optimal number of components based on mean squared
error} \item{intercept}{intercept of the optimal model, based on mean
squared error} \item{coefficients}{vector of regression coefficients of the
optimal model, based on mean squared error} \item{cor.error.matrix}{matrix
of cross-validated errors based on correlation. A row corresponds to one
cross-validation split.} \item{cor.error}{vector of cross-validated errors
based on correlation} \item{m.opt.cor}{optimal number of components based on
correlation} \item{intercept.cor}{intercept of the optimal model, based on
correlation} \item{coefficients.cor}{vector of regression coefficients of
the optimal model, based on correlation}

\item{coefficients.jackknife}{Array of the regression coefficients on each
of the cross-validation splits, if \code{compute.jackknife=TRUE}. In this
case, the dimension is \code{ncol(X) x (m+1) x k}.}
}
\description{
This function computes the optimal model parameter using cross-validation.
Mdel selection is based on mean squared error and correlation to the
response, respectively.
}
\details{
The function computes the principal components on the scaled predictors.
Based on the regression coefficients \code{coefficients.jackknife} computed
on the cross-validation splits, we can estimate their mean and their
variance using the jackknife. We remark that under a fixed design and the
assumption of normally distributed \code{y}-values, we can also derive the
true distribution of the regression coefficients.
}
\examples{

n<-500 # number of observations
p<-5 # number of variables
X<-matrix(rnorm(n*p),ncol=p)
y<-rnorm(n)

# compute PCR 
pcr.object<-pcr.cv(X,y,scale=FALSE,m=3)
pcr.object1<-pcr.cv(X,y,groups=sample(c(1,2,3),n,replace=TRUE),m=3)

}
\seealso{
\code{\link{pls.model}}, \code{\link{pls.ic}}
}
\author{
Nicole Kraemer, Mikio L. Braun
}
\keyword{multivariate}
