% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim_reduction.R
\name{dim_reduction}
\alias{dim_reduction}
\title{Reduce Dimension of Data for Exploratory Data Analysis}
\usage{
dim_reduction(omicsData, k = 2)
}
\arguments{
\item{omicsData}{an object of the class 'pepdata', 'prodata', 'metabData',
'lipidData', 'nmrData', or 'seqData', created by \code{\link{as.pepData}},
\code{\link{as.proData}}, \code{\link{as.metabData}},
\code{\link{as.lipidData}}, \code{\link{as.nmrData}}, or
\code{\link{as.seqData}}, respectively.}

\item{k}{integer number of principal components to return. Defaults to 2.}
}
\value{
a data.frame with first \code{k} principal component scores, sample
  identifiers, and group membership for each sample (if group designation was
  previously run on the data). The object is of class dimRes (dimension
  reduction Result).
}
\description{
For data types other than seqData, this function calculates principal
components using projection pursuit estimation, which implements an
expectation-maximization (EM) estimation algorithm when data is missing. For
seqData counts, a generalized version of principal components analysis for
non-normally distributed data is calculated under the assumption of a
negative binomial distribution with global dispersion.
}
\details{
Any biomolecules seen in only one sample or with a variance less
  than 1E-6 across all samples are not included in the PCA calculations. This
  function leverages code from \code{\link[pcaMethods]{pca}} and
  \code{\link[glmpca]{glmpca}} .
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)

mylipid <- edata_transform(omicsData = lipid_neg_object, data_scale = "log2")
mylipid <- group_designation(omicsData = mylipid, main_effects = "Virus")
pca_lipids <- dim_reduction(omicsData = mylipid)

\donttest{
myseq <- group_designation(omicsData = rnaseq_object, main_effects = "Virus")
pca_seq <- dim_reduction(omicsData = myseq)
}
\dontshow{\}) # examplesIf}
}
\references{
Redestig H, Stacklies W, Scholz M, Selbig J, & Walther
  D (2007). \emph{pcaMethods - a bioconductor package providing PCA methods
  for incomplete data}. Bioinformatics. 23(9): 1164-7.

  Townes FW, Hicks SC, Aryee MJ, Irizarry RA (2019). \emph{Feature selection
  and dimension reduction for single-cell RNA-seq based on a multinomial
  model.} Genome Biol. 20, 1–16.

  Huang H, Wang Y, Rudin C, Browne EP (2022). \emph{Towards a comprehensive
  evaluation of dimension reduction methods for transcriptomic data
  visualization.} Communications Biology 5, 719.
}
