% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingval_result.R
\name{missingval_result}
\alias{missingval_result}
\title{Creates an object of class naRes (NA Result)}
\usage{
missingval_result(omicsData)
}
\arguments{
\item{omicsData}{an object of class "pepData", "proData", "metabData",
"lipidData", "nmrData", or "seqData", created by \code{\link{as.pepData}},
\code{\link{as.proData}}, \code{\link{as.metabData}},
\code{\link{as.lipidData}}, \code{\link{as.nmrData}}, or
\code{\link{as.seqData}}, respectively.}
}
\value{
S3 object of class naRes, which is a list of two data frames, one
  containing the number of missing values per sample, and the other
  containing the number of missing values per molecule. For count data,
  zeroes represent missing values; for abundance data, NA's represent missing
  values. This object can be used with 'plot' and 'summary' methods to
  examine the missing values in the dataset.
}
\description{
This function takes in an omicsData object, and outputs a list of two data
frames, one containing the number of missing values by sample, and the other
containing the number of missing values by molecule
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
result1 = missingval_result(omicsData = lipid_neg_object)
result2 = missingval_result(omicsData = metab_object)
\dontshow{\}) # examplesIf}
}
