% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbinary_rs.R
\name{rbinary_rs}
\alias{rbinary_rs}
\title{Random Binary Variable}
\usage{
rbinary_rs(n = 10, p1 = 0.5, pmean = 0, psd = 1)
}
\arguments{
\item{n}{The number of random numbers
to generate.}

\item{p1}{The probability of being
1, before rescaling.}

\item{pmean}{Population mean.}

\item{psd}{Population standard
deviation.}
}
\value{
A vector of the generated
random numbers.
}
\description{
Generate random numbers
from a distribution of 0 or 1,
rescaled to have user-specified
population mean and standard
deviation.
}
\details{
First, specify probability of 1
(\code{p1}), and the desired population
mean and standard deviation. The
random numbers, drawn from a
distribution of 0 (\code{1 - p1}
probability) and 1 (\code{p1}
probability), will then be rescaled
with the desired population mean and
standard.
}
\examples{
set.seed(90870962)
x <- rbinary_rs(n = 5000,
                p1 = .5,
                pmean = 3,
                psd = 1)
mean(x)
sd(x)
hist(x)

}
