% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WD_Linnet.r
\name{WD_Linnet}
\alias{WD_Linnet}
\title{Linnet proportional CV weighted Deming}
\usage{
WD_Linnet(X, Y, lambda=1, MDL=NA, getCI=TRUE, epsilon=1e-9, printem=FALSE)
}
\arguments{
\item{X}{the vector of predicate readings,}

\item{Y}{the vector of test readings,}

\item{lambda}{ratio of g function to h function,}

\item{MDL}{optional medical decision limit(s),}

\item{getCI}{if TRUE, generates jackknife standard errors,}

\item{epsilon}{optional tolerance limit,}

\item{printem}{if TRUE, prints out results as a \code{message}.}
}
\value{
A list containing the following components:

\item{alpha }{the fitted intercept}
\item{beta }{the fitted slope}
\item{cor }{the Pearson correlation between X and Y}
\item{sealpha }{the jackknife standard error of alpha}
\item{sebeta }{the jackknife standard error of beta}
\item{covar }{the jackknife covariance between alpha and beta}
\item{preMDL }{the predictions at the MDL(s)}
\item{preMDLl }{the lower confidence limit(s) of preMDL}
\item{preMDLu }{the upper confidence limit(s) of preMDL}
}
\description{
This routine, provided for convenience, makes Linnet’s constant CV fit.
}
\examples{
# library
library(ppwdeming)

# parameter specifications
alpha <- 1
beta  <- 1.1
true  <- 8*10^((0:99)/99)
truey <- alpha+beta*true
kappa <- 0.1

# simulate single sample - set seed for reproducibility
set.seed(1039)
# specifications for predicate method
X     <- true *(1+kappa*rnorm(100))
# specifications for test method
Y     <- truey *(1+kappa*rnorm(100))

# fit with to estimate linear parameters
wd_fit <- WD_Linnet(X, Y, MDL=12, printem=TRUE)
cat("\nThe Linnet constant-CV estimated intercept is",
    signif(wd_fit$alpha,4), "and the estimated slope is",
    signif(wd_fit$beta,4), "\n")

}
\references{
Linnet K (1993). Evaluation of regression procedures for methods
comparison studies. \emph{Clinical Chemistry}, \strong{39}, 424-432.
}
\author{
Douglas M. Hawkins, Jessica J. Kraker \href{mailto:krakerjj@uwec.edu}{krakerjj@uwec.edu}
}
