% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primerTree.R
\name{calc_rank_dist_ave}
\alias{calc_rank_dist_ave}
\title{Summarize pairwise differences.}
\usage{
calc_rank_dist_ave(x, ranks = common_ranks)
}
\arguments{
\item{x}{a primerTree object}

\item{ranks}{ranks to show unique counts for, defaults to the common ranks}
}
\value{
returns a data frame of results
}
\description{
Summarize pairwise differences.
}
\details{
The purpose of this function is to calculate the average number
of nucleotide differences between species within each taxa of given taxonomic
level.

For example, at the genus level, the function calculates the average number
of nucleotide differences between all species within each genus and reports
the mean of those values.

There are several key assumptions and calculations made in this
function.

First, the function randomly selects one sequence from each species
in the primerTree results. This is to keep any one species (e.g.
human, cow, etc.) with many hits from skewing the results.

Second, for each taxonomic level tested, the function divides the
sequences by each taxon at that level and calculates the mean
number of nucleotide differences within that taxa, then returns the
mean of those values.

Third, when calculating the average distance, any taxa for which
there is only one species is omitted, as the number of nucleotide
differences will always be 0.
}
\examples{
\dontrun{
calc_rank_dist_ave(mammals_16S)

calc_rank_dist_ave(bryophytes_trnL)

# Note that the differences between the results from these two primers
# the mean nucleotide differences is much higher for the mammal primers
# than the byrophyte primers. This suggests that the mammal primers have
# better resolution to distinguish individual species.
}
}
