% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StudySpecificationAccessors.R
\name{.apply_dichotomy}
\alias{.apply_dichotomy}
\title{(Internal) Applies dichotomy to treatment}
\usage{
.apply_dichotomy(txt, dichotomy)
}
\arguments{
\item{txt}{A named \code{data.frame} containing a column of the treatment,
such as that produed by \code{treatment(myspecification)}, and any variables
specified in \code{dichotomy}.}

\item{dichotomy}{A formula specifying how to dichotomize the non-binary
treatment column in \code{txt} (or a call that evaluates to a formula).
See the Details section of the \code{ett()} or \code{att()} help pages for
information on specifying this formula}
}
\value{
A \code{vector} of binary treatments
}
\description{
Given a dichotomy formula and a \code{data.frame} with a
treatment variable and any variables in the formula, returns a
\code{vector} containing only \code{0}, \code{1}, or \code{NA}.
}
\keyword{internal}
