% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psymet_functions.R
\name{.gtheorys}
\alias{.gtheorys}
\title{Bootstrap Function for \code{gtheorys()} Function}
\usage{
.gtheorys(dat, i, nm.list, cross.vrb)
}
\arguments{
\item{dat}{data.frame of data. It can contain variables other than those used
for generalizability theory coefficient calculation.}

\item{i}{integer vector of length = \code{nrow(dat)} specifying which rows
should be included in the computation. When used by the \code{boot::boot}
function this argument will change with every new bootstrapped resample.}

\item{nm.list}{list of character vectors specifying the sets of
variables/items associated with each of the generalizability theory
coefficient calculations.}

\item{cross.vrb}{logical vector of length 1 specifying whether the
variables/items should be crossed when computing the generalizability
theory coefficient. If TRUE, then only the covariance structure of the
variables/items will be incorperated into the estimate of reliability. If
FALSE, then the mean structure of the variables/items will be incorperated.}
}
\value{
double vector of length = \code{length(nm.list)} providing the
  generalizability theory coefficients.
}
\description{
\code{.gtheorys} is the function used by the \code{\link[boot]{boot}}
function within the \code{\link{gtheorys}} function. It is primarily created
to increase the computational efficiency of bootstrap confidence intervals
within the \code{gtheorys} function by doing only the minimal computations
needed to compute the generalizability theory coefficient.
}
\examples{
dat0 <- psych::bfi[1:250, ]
dat1 <- str2str::pick(x = dat0, val = c("A1","C4","C5","E1","E2","O2","O5",
   "gender","education","age"), not = TRUE, nm = TRUE)
vrb_nm_list <- lapply(X = str2str::sn(c("E","N","C","A","O")), FUN = function(nm) {
   str2str::pick(x = names(dat1), val = nm, pat = TRUE)})
.gtheorys(dat = dat1,
   i = sample(x = 1:nrow(dat1), size = nrow(dat1), replace = TRUE),
   nm.list = vrb_nm_list, cross.vrb = TRUE)
.gtheorys(dat = dat1,
   i = sample(x = 1:nrow(dat1), size = nrow(dat1), replace = TRUE),
   nm.list = vrb_nm_list, cross.vrb = FALSE)
}
\seealso{
\code{\link{.gtheory}}
   \code{\link{gtheorys}}
}
