% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportResults.R
\name{exportResults}
\alias{exportResults}
\title{Export rChEA3 Results to Excel}
\usage{
exportResults(
  results,
  output_dir,
  output_file = "rChEA3_results",
  with_date = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{results}{A named list of data frames (e.g., the return of
\code{queryChEA3()}), where each element corresponds to a ChEA3
collection (e.g., "Integrated--meanRank", "ENCODE--ChIP-seq", etc.).
A single data frame is also accepted and will be written to one sheet.}

\item{output_dir}{A string specifying the output directory. This parameter
is required and has no default.}

\item{output_file}{Base file name (without extension). Default: \code{"rChEA3_results"}.}

\item{with_date}{Logical; if \code{TRUE}, prepend today's date (ISO, \code{YYYY-MM-DD})
to the file name. Default: \code{TRUE}.}

\item{verbose}{Logical; if \code{TRUE}, print the saved path. Default: \code{TRUE}.}
}
\value{
(Invisibly) the full path to the saved \code{.xlsx} file.
}
\description{
Write a rChEA3 results object (named list of data frames, one per collection)
to an Excel workbook, with one sheet per collection.
}
\examples{
\donttest{
    data(a549_dex_downreg)
    results <- queryChEA3(genes = a549_dex_downreg, query_name = "test_a549_dex_downreg")
    exportResults(results,
    output_dir = tempdir(),
    output_file = "rChEA3_results_a549_dex_downreg.xlsx")
}
}
