% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{prepare_init_vals}
\alias{prepare_init_vals}
\title{Preparation of Initial Values for MCMC Sampler}
\usage{
prepare_init_vals(stan_data, mmrm_initial, chains, covariance, prior_cov)
}
\arguments{
\item{stan_data}{A list containing the Stan data.}

\item{mmrm_initial}{A list containing the initial values from the MMRM, including attribute \code{cov_param_names}
specifying the names of the covariance parameters.}

\item{chains}{The number of chains.}

\item{covariance}{A character string indicating the type of covariance structure.}

\item{prior_cov}{A character string indicating the type of prior for the covariance parameters.}
}
\value{
A list of initial values for the MCMC sampler.
}
\description{
This function is used by \code{\link[=complete_control_bayes]{complete_control_bayes()}} when the \code{init} argument is set to \code{"mmrm"}.
}
\keyword{internal}
