% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FFTrees_riskyr.R
\name{FFTrees_riskyr}
\alias{FFTrees_riskyr}
\title{Convert from FFTrees to riskyr objects.}
\usage{
FFTrees_riskyr(x, data = "train", tree = 1)
}
\arguments{
\item{x}{An \code{FFTrees} object (generated by \bold{FFTrees}).}

\item{data}{The type of data to consider (as a character string).
Must be either "train" (for training/fitting data) or
"test" (for test/prediction data).
Default: \code{data = "train"}.}

\item{tree}{An integer specifying the tree to consider (as an integer).
Default: \code{tree = 1}.}
}
\value{
A \bold{riskyr} scenario (as \code{riskyr} object).
}
\description{
\code{FFTrees_riskyr} converts an \code{FFTrees} object
--- as generated by the \bold{FFTrees} package ---
into a corresponding \code{riskyr} object.
}
\details{
\code{FFTrees_riskyr} essentially allows using \bold{riskyr} functions
to visualize a fast-and-frugal tree (FFT)'s performance information
(as contained in a 2x2 matrix of frequency counts).

The R package \strong{FFTrees} creates, visualizes, and
evaluates fast-and-frugal trees (FFTs) for solving binary
classification problems in an efficient and transparent fashion.
}
\references{
See \url{https://CRAN.R-project.org/package=FFTrees} or
\url{https://github.com/ndphillips/FFTrees} for information
on the R package \strong{FFTrees}.
}
\seealso{
\code{\link{riskyr}} initializes a \code{riskyr} scenario.
}
\concept{conversion functions}
