% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_classical_hotelling_t2_phase2_chart.R
\name{plot_classical_hotelling_t2_phase2_chart}
\alias{plot_classical_hotelling_t2_phase2_chart}
\title{Plot Classical Hotelling T2 Control Chart - Phase 2}
\usage{
plot_classical_hotelling_t2_phase2_chart(
  t2_statistics,
  num_vars,
  title = "Classical Hotelling T2 Control Chart (Phase 2)"
)
}
\arguments{
\item{t2_statistics}{A data frame with columns \code{Batch}, \code{T2_Stat}, and \code{Status}.}

\item{num_vars}{Integer. Number of variables used in the multivariate analysis (degrees of freedom for Chi²).}

\item{title}{Optional string. Plot title.}
}
\value{
A ggplot2 object with the Phase 2 control chart.
}
\description{
Plots the classical Hotelling T² statistics per batch for Phase 2 data,
using the reference mean and covariance matrix estimated from Phase 1.
Batches are color-coded by control status ("Under Control" = blue, "Out of Control" = red).
}
\examples{
# Simulate pharmaceutical manufacturing batches
sim_batches <- simulate_pharma_batches()

# Split by phase
phase1_data <- subset(sim_batches, Phase == "Phase 1")
phase2_data <- subset(sim_batches, Phase == "Phase 2")

# Fit Phase 1 classical estimators
t2_phase1 <- hotelling_t2_phase1(
  data = phase1_data,
  variables = c("Concentration", "Humidity", "Dissolution", "Density")
)

# Evaluate Phase 2 batches
t2_phase2 <- hotelling_t2_phase2(
  new_data = phase2_data,
  variables = c("Concentration", "Humidity", "Dissolution", "Density"),
  center = t2_phase1$center,
  covariance = t2_phase1$covariance
)

# Combine with status for plotting
status_info <- phase2_data[!duplicated(phase2_data$Batch), "Status"]
t2_phase2_plot <- cbind(t2_phase2$batch_statistics, Status = status_info)

# Plot Phase 2 control chart
plot_classical_hotelling_t2_phase2_chart(
  t2_statistics = t2_phase2_plot,
  num_vars = 4
)
}
