% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.kroclearn.R
\name{summary.kroclearn}
\alias{summary.kroclearn}
\title{Summarize a fitted kernel model}
\usage{
\method{summary}{kroclearn}(object, ...)
}
\arguments{
\item{object}{A fitted model of class \code{"kroclearn"}.}

\item{...}{Unused.}
}
\value{
Invisibly returns \code{object} after printing a formatted summary.
}
\description{
Display key information from a fitted \code{"kroclearn"} object, including:
data dimensions, kernel specification, convergence status, training time,
and leading coefficient estimates.
}
\examples{
set.seed(123)
n <- 100
r <- sqrt(runif(n, 0.05, 1))
theta <- runif(n, 0, 2*pi)
X <- cbind(r * cos(theta), r * sin(theta))
y <- ifelse(r < 0.5, 1, -1)

fit <- kroclearn(X, y, lambda = 0.1, kernel = "radial", approx=TRUE)
summary(fit)
}
\seealso{
\code{\link{kroclearn}}, \code{\link{summary.roclearn}},
\code{\link{cv.kroclearn}}, \code{\link{cv.roclearn}}
}
