% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_phylopic.r
\name{add_phylopic}
\alias{add_phylopic}
\title{Annotate a ggplot plot with PhyloPics}
\usage{
add_phylopic(
  img = NULL,
  name = NULL,
  uuid = NULL,
  filter = NULL,
  x,
  y,
  ysize = deprecated(),
  height = NA,
  width = NA,
  alpha = 1,
  color = NA,
  fill = "black",
  horizontal = FALSE,
  vertical = FALSE,
  angle = 0,
  hjust = 0.5,
  vjust = 0.5,
  remove_background = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{img}{A \link[grImport2:Picture-class]{Picture} or png array object, e.g.,
from using \code{\link[=get_phylopic]{get_phylopic()}}.}

\item{name}{\code{character}. A taxonomic name to be passed to \code{\link[=get_uuid]{get_uuid()}}.}

\item{uuid}{\code{character}. A valid uuid for a PhyloPic silhouette (such as
that returned by \code{\link[=get_uuid]{get_uuid()}} or \code{\link[=pick_phylopic]{pick_phylopic()}}).}

\item{filter}{\code{character}. Filter by usage license if \code{name} is defined.
Use "by" to limit results to images which do not require attribution, "nc"
for images which allows commercial usage, and "sa" for images without a
ShareAlike clause. The user can also combine these filters as a vector.}

\item{x}{\code{numeric}. x value of the silhouette center.}

\item{y}{\code{numeric}. y value of the silhouette center.}

\item{ysize}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} use the \code{height} or \code{width}
argument instead.}

\item{height}{\code{numeric}. Height of the silhouette in coordinate space.
If "NA", the default, and \code{width} is "NA", the silhouette will be as large
as fits in the plot area. If "NA" and \code{width} is specified, the height is
determined by the aspect ratio of the original image. One or both of
\code{height} and \code{width} must be "NA".}

\item{width}{\code{numeric}. Width of the silhouette in coordinate space. If
"NA", the default, and \code{height} is "NA", the silhouette will be as large as
fits in the plot area. If "NA", the default, and \code{height} is specified, the
width is determined by the aspect ratio of the original image. One or both
of \code{height} and \code{width} must be "NA".}

\item{alpha}{\code{numeric}. A value between 0 and 1, specifying the opacity
of the silhouette (0 is fully transparent, 1 is fully opaque).}

\item{color}{\code{character}. Color of silhouette outline. If "original" or
NA is specified, the original color of the silhouette outline will be used
(usually the same as "transparent"). To remove the outline, you can set
this to "transparent".}

\item{fill}{\code{character}. Color of silhouette. If "original" is
specified, the original color of the silhouette will be used (usually the
same as "black"). If \code{color} is specified and \code{fill} is NA, \code{color} will be
used as the fill color (for backwards compatibility). To remove the fill,
you can set this to "transparent".}

\item{horizontal}{\code{logical}. Should the silhouette be flipped
horizontally?}

\item{vertical}{\code{logical}. Should the silhouette be flipped vertically?}

\item{angle}{\code{numeric}. The number of degrees to rotate the silhouette
clockwise. The default is no rotation.}

\item{hjust}{\code{numeric}. A numeric vector between 0 and 1 specifying
horizontal justification (left = 0, center = 0.5, right = 1). Note that,
due to the enforcement of the silhouette's aspect ratio, there may be
unexpected behavior due to interactions between the aspect ratio of the
plot and the aspect ratio of the silhouette.}

\item{vjust}{\code{numeric}. A numeric vector between 0 and 1 specifying
vertical justification (top = 1, middle = 0.5, bottom = 0). Note that, due
to the enforcement of the silhouette's aspect ratio, there may be
unexpected behavior due to interactions between the aspect ratio of the
plot and the aspect ratio of the silhouette.}

\item{remove_background}{\code{logical}. Should any white background be
removed from the silhouette(s)? See \code{\link[=recolor_phylopic]{recolor_phylopic()}} for details.}

\item{verbose}{\code{logical}. Should the attribution information for the
used silhouette(s) be printed to the console (see \code{\link[=get_attribution]{get_attribution()}})?}
}
\description{
Specify existing images, taxonomic names, or PhyloPic uuids to add PhyloPic
silhouettes as a separate layer to an existing ggplot plot.
}
\details{
One (and only one) of \code{img}, \code{name}, or \code{uuid} must be specified.
Use parameters \code{x}, \code{y}, and \code{ysize} to place the silhouette at a specified
position on the plot. The aspect ratio of the silhouette will always be
maintained.

\code{x} and/or \code{y} may be vectors of numeric values if multiple silhouettes
should be plotted at once. In this case, any other arguments (except for
\code{remove_background}) may also be vectors of values, which will be recycled
as necessary.

When specifying a horizontal and/or vertical flip \strong{and} a rotation, the
flip(s) will always occur first. If you would like to customize this
behavior, you can flip and/or rotate the image within your own workflow
using \code{\link[=flip_phylopic]{flip_phylopic()}} and \code{\link[=rotate_phylopic]{rotate_phylopic()}}.

Note that png array objects can only be rotated by multiples of 90 degrees.
Also, outline colors do not currently work for png array objects.
}
\examples{
\dontrun{
# Put a silhouette behind a plot based on a taxonomic name
library(ggplot2)
ggplot(iris) +
  add_phylopic(x = 6.1, y = 3.2, name = "Iris", alpha = 0.2) +
  geom_point(aes(x = Sepal.Length, y = Sepal.Width))

# Put a silhouette in several places based on UUID
posx <- runif(10, 0, 10)
posy <- runif(10, 0, 10)
heights <- runif(10, 0.4, 2)
angle <- runif(10, 0, 360)
hor <- sample(c(TRUE, FALSE), 10, TRUE)
ver <- sample(c(TRUE, FALSE), 10, TRUE)
fills <- sample(c("black", "darkorange", "grey42", "white"), 10,
  replace = TRUE)
alpha <- runif(10, 0.3, 1)

p <- ggplot(data.frame(cat.x = posx, cat.y = posy), aes(cat.x, cat.y)) +
  geom_blank() +
  add_phylopic(uuid = "23cd6aa4-9587-4a2e-8e26-de42885004c9",
               x = posx, y = posy, height = heights,
               fill = fills, alpha = alpha, angle = angle,
               horizontal = hor, vertical = ver)
p + ggtitle("R Cat Herd!!")
}
}
