% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MB_Server.R
\name{MB_fetch_mdl}
\alias{MB_fetch_mdl}
\title{Fetch Model Builder Module Models}
\usage{
MB_fetch_mdl(state)
}
\arguments{
\item{state}{MB state from \code{MB_fetch_state()}}
}
\value{
list containing the following elements
\itemize{
\item{isgood:}      Return status of the function.
\item{hasmdl:}      Boolean indicator if the module has any models
\item{msgs:}        Messages to be passed back to the user.
\item{mdl:}         List with models. Each list element has the name of
the R-object for that dataset. Each element has the following structure:
\itemize{
\item{label:}       Text label for the model (e.g. one-compartment model).
\item{MOD_TYPE:}    Type of module.
\item{id:}          Module ID.
\item{rx_obj:}      The rxode2 object.
\item{rx_obj_name:} The rxode2 object name that holds the model.
\item{ts_obj}       List with elements system and details
\item{ts_obj_name:} The object name that holds the model time scale information.
\item{fcn_def:}     Text to define the model
\item{MDLMETA:}     Notes about the model.
\item{code:}        Code to generate the model.
\item{checksum:}    Module checksum.
\item{MDLchecksum:} Model checksum.
}
}
}
\description{
Fetches the models contained in the module.
}
\examples{
# We need a module state:
sess_res = MB_test_mksession()
state = sess_res$state

mdls = MB_fetch_mdl(state)

names(mdls)
}
