% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_draw.R
\name{extract_draw}
\alias{extract_draw}
\title{Extract a Single Draw From an Rvec}
\usage{
extract_draw(x, i = NULL)
}
\arguments{
\item{x}{An \link[=rvec]{rvec}.}

\item{i}{Index for the draw
to be extracted. A number between
\code{1} and \code{n_draw(x)}. If no value is
supplied, a draw is chosen at random.}
}
\value{
A vector, with type
\itemize{
\item double, if \code{x} has class \code{"rvec_dbl"},
\item integer, if \code{x} has class \code{"rvec_int"},
\item character, if \code{x} has class \code{"rvec_chr"},
\item logical, if \code{x} has class \code{"rvec_lgl"}.
}
}
\description{
Extract a single draw from \code{x}.
If a value is supplied for \code{i},
extract the \code{i}th draw; otherwise
extract a random draw.
}
\examples{
x <- rvec(matrix(1:50, ncol = 5))
extract_draw(x, i = 1)
extract_draw(x)
}
\seealso{
\code{\link[=n_draw]{n_draw()}} Number of draws
}
