% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available.R
\name{available}
\alias{available}
\title{Available R Builds}
\usage{
available(platform = current_r_platform())
}
\arguments{
\item{platform}{Operating system version. Defaults to
\code{\link[=current_r_platform]{current_r_platform()}}. Possible values are:
\itemize{
\item \code{windows}: x86_64 Windows.
\item \code{windows-x86_64}: the same.
\item \code{windows-aarch64}: aarch64 Windows.
\item \code{macos}: arm64 macOS.
\item \code{macos-arm64}: the same.
\item \code{macos-x86_64}: x86_64 macOS.
\item \verb{linux-<distro>-<release>}: x86_64 Linux on the given distribution
and release, e.g. \code{linux-ubuntu-22.04}.
\item A target triplet of the form \code{cpu-vendor-os-abi}. On Linux it should
also include the distribution name and release. See
\code{\link[=current_r_platform]{current_r_platform()}} for examples.
}}
}
\value{
A data frame with columns \code{version}, \code{date}, \code{semver}, \code{type},
and \code{url}.
}
\description{
Available R Builds
}
\details{
\code{available()} caches its results in the current R session. To clear the
cache restart R or set the \code{R_VERSION_CACHE_TIMEOUT} environment
variable to \code{0}.
}
\examples{
\dontshow{if (rversions:::is_online()) withAutoprint(\{ # examplesIf}
available()
available("windows")
available("macos-arm64")
available("linux-gnu-ubuntu-24.04")
available("aarch64-unknown-linux-gnu-ubuntu-22.04")
\dontshow{\}) # examplesIf}
}
