% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define-SOM.R
\docType{class}
\name{SMSE-class}
\alias{SMSE-class}
\title{Class \code{"SMSE"}}
\description{
Stores the outputs from the simulation of salmon operating models.
}
\details{
In generation \eqn{t}, proportionate natural influence (PNI) is defined as:

\deqn{\textrm{PNI}_t = \dfrac{p^\textrm{NOB}_t}{p^\textrm{NOB}_t + p^\textrm{HOSeff}_t}}

with \eqn{p^\textrm{HOSeff} = \textrm{HOSeff}/(\textrm{NOS} + \textrm{HOSeff})}.

The proportion of wild salmon is defined as:

\deqn{p^{\textrm{WILD}}_t = q^\textrm{HOScen}_t
\dfrac{(q^\textrm{HOScen}_{t-1})^2}
{(q^\textrm{HOScen}_{t-1})^2 + 2\gamma \times p^\textrm{HOScen}_{t-1} q^\textrm{HOScen}_{t-1} +
\gamma^2 (p^\textrm{HOScen}_{t-1})^2}}

where \eqn{q = 1-p} and \eqn{p^\textrm{HOScen} = \textrm{HOS}/(\textrm{NOS} + \textrm{HOS})}.
}
\section{Slots}{

\describe{
\item{\code{Name}}{Character. Identifying name}

\item{\code{nyears}}{Integer. The number of historical years}

\item{\code{proyears}}{Integer. The number of projected years}

\item{\code{nsim}}{Integer. The number of simulations}

\item{\code{nstocks}}{Integer. The number of stocks}

\item{\code{Snames}}{Character. Stock names}

\item{\code{Egg_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Spawning output, i.e., egg production, of natural origin spawners.}

\item{\code{Egg_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Spawning output of hatchery origin spawners.}

\item{\code{Fry_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Fry that are offspring of natural origin spawners.}

\item{\code{Fry_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Fry that are offspring of hatchery origin spawners.}

\item{\code{Smolt_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Smolts that are offspring of natural origin spawners.}

\item{\code{Smolt_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Smolts that are offspring of hatchery origin spawners.}

\item{\code{Smolt_Rel}}{Array \verb{[nsim, nstocks, proyears]}. Smolts that are offspring of broodtake, i.e., hatchery releases.}

\item{\code{Njuv_NOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. Abundance of juvenile natural origin fish at the beginning of the year.}

\item{\code{Njuv_HOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. Abundance of juvenile hatchery origin fish at the beginning of the year.}

\item{\code{Return_NOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. Mature fish that will be natural origin spawners.}

\item{\code{Return_HOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. Mature fish that will be hatchery origin spawners.}

\item{\code{Escapement_NOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. The escapement of mature fish that will be natural origin spawners.}

\item{\code{Escapement_HOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. The escapement of mature fish that will be hatchery origin spawners.}

\item{\code{NOB}}{Array \verb{[nsim, nstocks, proyears]}. Natural origin broodtake.}

\item{\code{HOB}}{Array \verb{[nsim, nstocks, proyears]}. Hatchery origin broodtake (local + strays).}

\item{\code{HOB_stray}}{Array \verb{[nsim, nstocks, proyears]}. Hatchery origin broodtake (strays only).}

\item{\code{HOB_import}}{Array \verb{[nsim, nstocks, proyears]}. Imported hatchery origin broodtake used for hatchery production.}

\item{\code{NOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. Natural origin spawners.}

\item{\code{HOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. Hatchery origin spawners (local + strays).}

\item{\code{HOS_stray}}{Array \verb{[nsim, nstocks, nage, proyears]}. Hatchery origin spawners (strays only).}

\item{\code{HOS_effective}}{Array \verb{[nsim, nstocks, nage, proyears]}. Hatchery origin spawners (local + strays) discounted by \code{gamma}.}

\item{\code{KPT_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Pre-terminal fishery kept catch of natural origin spawners.}

\item{\code{KT_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Terminal fishery kept catch of natural origin spawners.}

\item{\code{KPT_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Pre-terminal fishery kept catch of hatchery origin spawners.}

\item{\code{KT_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Terminal fishery kept catch of hatchery origin spawners.}

\item{\code{DPT_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Pre-terminal fishery released catch (live and dead) of natural origin spawners.}

\item{\code{DT_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Terminal fishery released catch (live and dead) of natural origin spawners.}

\item{\code{DPT_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Pre-terminal fishery released catch (live and dead) of hatchery origin spawners.}

\item{\code{DT_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Terminal fishery released catch (live and dead) hatchery origin spawners.}

\item{\code{UPT_NOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. Pre-terminal fishery harvest rate (from kept catch) of natural origin spawners.}

\item{\code{UT_NOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. Terminal fishery harvest rate of natural origin spawners.}

\item{\code{UPT_HOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. Pre-terminal fishery harvest rate of hatchery origin spawners.}

\item{\code{UT_HOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. Terminal fishery harvest rate of hatchery origin spawners.}

\item{\code{ExPT_NOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. Pre-terminal fishery exploitation rate (from kept catch and dead releases) of natural origin spawners.}

\item{\code{ExT_NOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. Terminal fishery exploitation rate of natural origin spawners.}

\item{\code{ExPT_HOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. Pre-terminal fishery exploitation rate of hatchery origin spawners.}

\item{\code{ExT_HOS}}{Array \verb{[nsim, nstocks, nage, proyears]}. Terminal fishery exploitation rate of hatchery origin spawners.}

\item{\code{fitness}}{Array \verb{[nsim, nstocks, 2, proyears]}. Fitness of the population in the natural (1) and hatchery (2) environments.}

\item{\code{pNOB}}{Array \verb{[nsim, nstocks, proyears]}. Proportion of natural fish in the brood.}

\item{\code{pHOS_census}}{Array \verb{[nsim, nstocks, proyears]}. Proportion of spawners of hatchery origin, weighted by age class fecundity.}

\item{\code{pHOS_effective}}{Array \verb{[nsim, nstocks, proyears]}. Proportion of spawners of hatchery origin, discounted by \code{gamma}, weighted by age class fecundity.}

\item{\code{PNI}}{Array \verb{[nsim, nstocks, proyears]}. Proportionate natural influence, index of gene flow from hatchery to the natural environment.}

\item{\code{p_wild}}{Array \verb{[nsim, nstocks, proyears]}. Proportion of wild spawners, natural spawners whose parents were also produced in the natural environment assuming
non-assortative mating, defined under Canada's Wild Salmon Policy.}

\item{\code{Mjuv_loss}}{Array \verb{[nsim, nstocks, nage, proyears]}. Realized juvenile natural mortality, which may differ from inputs due to fitness loss.}

\item{\code{Misc}}{List. Miscellaneous output:
\itemize{
\item \code{Ref} for reference points
\item \code{SHist} for the \linkS4class{SHist} object
\item \code{SOM} for the \linkS4class{SOM} object.
\item \code{LHG} list \code{nstocks} long containing state variables by life history group
}}
}}

\section{Creating Object}{

Objects can be created by calls of the form \code{new("SMSE")}
}

\examples{
showClass("SMSE")
}
\references{
Withler et al. 2018. Genetically Based Targets for Enhanced Contributions to Canadian Pacific Chinook Salmon Populations.
DFO Can. Sci. Advis. Sec. Res. Doc. 2018/019. xii + 88 p.
}
\keyword{classes}
