% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIGER_Utilities.R
\name{Embeddings.liger}
\alias{Embeddings.liger}
\title{Extract matrix of embeddings}
\usage{
\method{Embeddings}{liger}(object, reduction = NULL, iNMF = FALSE, check_only = FALSE, ...)
}
\arguments{
\item{object}{LIGER object name.}

\item{reduction}{name of dimensionality reduction to pull}

\item{iNMF}{logical, whether to extract iNMF h.norm matrix instead of dimensionality reduction embeddings.}

\item{check_only}{logical, return \code{TRUE} if valid reduction is present.}

\item{...}{Arguments passed to other methods}
}
\value{
matrix
}
\description{
Extract matrix containing iNMF or dimensionality reduction embeddings.
}
\examples{
\dontrun{
# Extract embedding matrix for current dimensionality reduction
UMAP_coord <- Embeddings(object = liger_object)

# Extract iNMF h.norm matrix
iNMF_mat <- Embeddings(object = liger_object, reduction = "iNMF")
}

}
\concept{liger_object_util}
