% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PGN_Lasso.R
\name{PGN_Lasso}
\alias{PGN_Lasso}
\title{Peak-Gene Network via Lasso}
\usage{
PGN_Lasso(
  X,
  Y,
  gene_data,
  neibor_peak,
  dirpath = tempdir(),
  count_device = 1,
  rebuild_PGN_Lasso = TRUE,
  save_file = TRUE
)
}
\arguments{
\item{X}{The scATAC-seq data, sparse matrix.}

\item{Y}{The scRNA-seq data, sparse matrix.}

\item{gene_data}{The information for genes, must have a col names "gene_name".}

\item{neibor_peak}{The peak IDs within a certain range of each gene, must have cols c("gene_name", "start_use", "end_use"). The id numbers in "start_use" and "end_use" are start from 0.}

\item{dirpath}{The folder path to read or write file.}

\item{count_device}{The number of cpus used to train the Lasso model.}

\item{rebuild_PGN_Lasso}{Logical. Whether to rebuild the peak-gene network via Lasso from scratch. If FALSE, the function will attempt to read from \code{PGN_Lasso.mtx} under \cr \code{dirpath/test} in single mode or \code{dirpath/state_name/test} in compare mode.}

\item{save_file}{Logical, whether to save the output to a file.}
}
\value{
The PGN_Lasso network.
}
\description{
Construct the peak-gene network via Lasso.
}
\examples{
\donttest{
library(scPOEM)
dirpath <- "./example_data"
# Download single mode example data
data(example_data_single)
# Construct PGN net via Lasso.
net_Lasso <- PGN_Lasso(example_data_single$X,
                       example_data_single$Y,
                       example_data_single$gene_data,
                       example_data_single$neibor_peak,
                       file.path(dirpath, "single"),
                       save_file=FALSE)
}

}
