% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spvar.R
\name{spvar}
\alias{spvar}
\title{spatial variance}
\usage{
spvar(x, wt, method = c("cpp", "r"))
}
\arguments{
\item{x}{A numerical vector .}

\item{wt}{The spatial weight matrix.}

\item{method}{(optional) The method for calculating spatial variance, which can be chosen as
either \code{cpp} or \code{r}. Default is \code{cpp}.}
}
\value{
A numerical value.
}
\description{
spatial variance
}
\details{
The spatial variance formula is
\eqn{\Gamma = \frac{\sum_i \sum_{j \neq i} \omega_{ij}\frac{(y_i-y_j)^2}{2}}{\sum_i \sum_{j \neq i} \omega_{ij}}}
}
\examples{
gzma = sf::read_sf(system.file('extdata/gzma.gpkg',package = 'sdsfun'))
wt1 = inverse_distance_swm(gzma)
spvar(gzma$PS_Score,wt1)

}
