% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_sbt_std_boot.R
\name{print.sbt_std_boot}
\alias{print.sbt_std_boot}
\title{Print a 'sbt_std_boot' Object}
\usage{
\method{print}{sbt_std_boot}(
  x,
  ...,
  nd = 3,
  output = c("lavaan.printer", "text", "table"),
  standardized_only = TRUE,
  boot_ci_only = FALSE,
  drop_cols = "Z"
)
}
\arguments{
\item{x}{Object of the class
\code{sbt_std_boot}, the output of
\code{\link[=standardizedSolution_boot]{standardizedSolution_boot()}}.}

\item{...}{Optional arguments to be
passed to \code{\link[=print]{print()}} methods.}

\item{nd}{The number of digits
after the decimal place. Default
is 3.}

\item{output}{String. How the results
are printed. If set to \code{"table"},
the results are printed in a table
format similar to that of
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}.
If set to \code{"text"}, the results will be
printed in a text format similar to
the printout of the output of
\code{\link[=summary]{summary()}} of
a 'lavaan'-class object. If set
to \code{"lavaan.printer"}, the default,
\code{lavaan.printer}
will be used to print a more compact
version of the \code{"text"} output.}

\item{standardized_only}{Logical.
If \code{TRUE}, the default, only the
results for the standardized solution
will be printed. If \code{FALSE}, then
the standardized solution is printed
alongside the unstandardized solution,
as in the printout of the output
of \code{\link[=summary]{summary()}} of a 'lavaan'-class
object.}

\item{boot_ci_only}{Logical. Whether
only bootstrap confidence intervals
are printed. If \code{FALSE}, the default,
the delta method confidence intervals
by \code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}
are also printed.}

\item{drop_cols}{The name(s) of the
column(s) to drop
if output format is \code{"lavaan.printer"}.
Default is \code{"Z"}, to fit the print
out to the usual screen width of 80.}
}
\value{
\code{x} is returned invisibly. Called for its side effect.
}
\description{
Print method for a
'sbt_std_boot' object, which
is the output of
\code{\link[=standardizedSolution_boot]{standardizedSolution_boot()}}.
}
\details{
The default format of the printout,
\code{"lavaan.printer"},
is a compact version of the lavaan-style
printout, generated by \code{lavaan.printer}.
Alternatively, users can request a format
similar to that of the printout
of the summary of a \code{lavaan} output
by setting \code{output} to \code{"text"}. This
format can be used if \code{"lavaan.printer"}
failed.

Users can also print the content just
as a data frame by setting \code{output}
to \code{"table"}. Not easy to read much
more compact.

For the \code{"text"} or \code{"lavaan.printer"} format, users can
also select whether
only the standardized solution is
printed (the default) or whether
the standardized solution is appended
to the right of the printout.
}
\examples{
library(lavaan)
set.seed(5478374)
n <- 50
x <- runif(n) - .5
m <- .40 * x + rnorm(n, 0, sqrt(1 - .40))
y <- .30 * m + rnorm(n, 0, sqrt(1 - .30))
dat <- data.frame(x = x, y = y, m = m)
model <-
'
m ~ a*x
y ~ b*m
ab := a*b
'

# Should set bootstrap to at least 2000 in real studies
fit <- sem(model, data = dat, fixed.x = FALSE,
           se = "boot",
           bootstrap = 50)
std_out <- standardizedSolution_boot(fit)
std_out
print(std_out, standardized_only = FALSE)

}
\seealso{
\code{\link[=standardizedSolution_boot]{standardizedSolution_boot()}}
}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}
}
