% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.shrinkGPR}
\alias{plot.shrinkGPR}
\title{Graphical summary of posterior of theta}
\usage{
\method{plot}{shrinkGPR}(x, nsamp = 1000, ...)
}
\arguments{
\item{x}{a \code{shrinkGPR} object.}

\item{nsamp}{a positive integer specifying the number of posterior samples to draw for plotting.
The default is \code{1000}.}

\item{...}{further arguments passed to the internal \code{\link[graphics]{boxplot}} function,
such as axis labeling or plotting options. By default, \code{las = 2} is used unless explicitly
overridden by the user.}
}
\value{
Called for its side effects. Returns \code{invisible(NULL)}.
}
\description{
\code{plot.shrinkGPR} generates a boxplot visualizing the posterior distribution of
\code{theta} obtained from a fitted \code{shrinkGPR} object.
}
\examples{
\donttest{
# Simulate and fit a shrinkGPR model, then plot:
sim <- simGPR()
mod <- shrinkGPR(y ~ ., data = sim$data)
plot(mod)

## Change axis label orientation
plot(mod, las = 1)
}

}
\seealso{
Other plotting functions: 
\code{\link{plot.shrinkGPR_marg_samples_1D}()},
\code{\link{plot.shrinkGPR_marg_samples_2D}()},
\code{\link{plot.shrinkTPR}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{plotting functions}
