% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{genFormula}
\alias{genFormula}
\title{Generate a linear formula}
\usage{
genFormula(coefs, vars)
}
\arguments{
\item{coefs}{A vector that contains the values of the
coefficients. Coefficients can also be defined as character for use with 
double dot notation. If length(coefs) == length(vars), then no intercept
is assumed. Otherwise, an intercept is assumed.}

\item{vars}{A vector of strings that specify the names of the
explanatory variables in the equation.}
}
\value{
A string that represents the desired formula
}
\description{
Formulas for additive linear models can be generated
with specified coefficient values and variable names.
}
\examples{

genFormula(c(.5, 2, 4), c("A", "B", "C"))
genFormula(c(.5, 2, 4), c("A", "B"))

genFormula(c(.5, "..x", 4), c("A", "B", "C"))
genFormula(c(.5, 2, "..z"), c("A", "B"))

changeX <- c(7, 10)
genFormula(c(.5, 2, changeX[1]), c("A", "B"))
genFormula(c(.5, 2, changeX[2]), c("A", "B"))
genFormula(c(.5, 2, changeX[2]), c("A", "B", "C"))

newForm <- genFormula(c(-2, 1), c("A"))

def1 <- defData(varname = "A", formula = 0, variance = 3, dist = "normal")
def1 <- defData(def1, varname = "B", formula = newForm, dist = "binary", link = "logit")

set.seed(2001)
dt <- genData(500, def1)
summary(glm(B ~ A, data = dt, family = binomial))
}
\concept{generate_data}
