% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avns.R
\name{gen_nswn}
\alias{gen_nswn}
\title{Generate Non-Stationary White Noise Process}
\usage{
gen_nswn(n_total, title = NULL, seed = 135, ...)
}
\arguments{
\item{n_total}{An \code{integer} indicating the length of the simulated non-stationary white noise process.}

\item{title}{A \code{string} defining the name of the time series data.}

\item{seed}{An \code{integer} defined for simulation replication purposes.}

\item{...}{Additional parameters.}
}
\value{
A \code{vector} containing the non-stationary white noise process.
}
\description{
This function allows to generate a non-stationary white noise process.
}
\note{
This function generates a non-stationary white noise process whose theoretical maximum overlapping allan variance (MOAV) corresponds to the 
theoretical MOAV of the stationary white noise process. This example confirms that the allan 
variance is unable to distinguish between a stationary white noise process and a white noise 
process whose second-order behavior is non-stationary, as pointed out in the paper "A Study of 
the Allan Variance for Constant-Mean Non-Stationary Processes" by Xu et al. (IEEE Signal Processing 
Letters, 2017), preprint available: \url{https://arxiv.org/abs/1702.07795}.
}
\examples{
Xt = gen_nswn(n_total = 1000)
plot(Xt)

Yt = gen_nswn(n_total = 2000, title = "non-stationary 
white noise process", seed = 1960)
plot(Yt)
}
\author{
Yuming Zhang
}
