% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_functions_sf.R
\name{build_graph_cppr}
\alias{build_graph_cppr}
\title{Network generation with cppRouting}
\usage{
build_graph_cppr(lines, digits, line_weight, attrs = FALSE, direction = NULL)
}
\arguments{
\item{lines}{A feature collection of lines}

\item{digits}{The number of digits to keep from the coordinates}

\item{line_weight}{The name of the column giving the weight of the lines}

\item{attrs}{A boolean indicating if the original lines' attributes should be
stored in the final object}
}
\value{
A list containing the following elements:
\itemize{
\item graph: a cppRouting object;
\item linelist: the dataframe used to build the graph;
\item lines: the original feature collection of linestrings;
\item spvertices: a feature collection of points representing the vertices
of the graph;
\item digits : the number of digits kept for the coordinates.
}
}
\description{
Generate an cppRouting object from a feature collection of linestrings
}
\details{
This function can be used to generate an undirected graph object (cppRouting
object). It uses the coordinates of the linestrings extremities to create
the nodes of the graph. This is why the number of digits in the coordinates
is important. Too high precision (high number of digits) might break some
connections.
}
\examples{
\donttest{
data(mtl_network)
mtl_network$length <- as.numeric(sf::st_length(mtl_network))
graph_result <- build_graph_cppr(mtl_network, 2, "length", attrs = TRUE)
}
}
\keyword{internal}
