% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_plot.R
\name{rd_plot}
\alias{rd_plot}
\title{Residual Density Plot for Linear Models}
\usage{
rd_plot(mod, ...)
}
\arguments{
\item{mod}{a fitted linear model}

\item{...}{optional arguments, intended for adjusting the line width.}
}
\value{
\code{rd_plot()} returns a density plot a \pkg{ggplot2} object. A
density plot of the actual residuals is a solid black line. A stylized normal
distribution matching the description of the residuals is the blue dashed
line.
}
\description{
\code{rd_plot()} provides a visual diagnostic of the normality
assumption of the linear model. Provided an OLS model fit by \code{lm()} in
base R, the function extracts the residuals of the model and creates
a density plot of those residuals (solid black line) against a standard
normal distribution with a mean of 0 and a standard deviation matching the
standard deviation of the residuals from the model. The function may be used
for diagnostic purposes.
}
\details{
The user can always add \pkg{ggplot2} elements on top of this for
greater legibility/clarity. For example, density plots can be finicky about
making observations appear where they don't. Perhaps adjusting the scale
of \code{x} ad hoc, after the fact, may be warranted.

The goal of this function is to emphasize that in many real world applications,
the normality assumption of the residuals is never held but can often be
reasonably approximated upon visual inspection.
}
\examples{

M1 <- lm(mpg ~ hp + disp, data = mtcars)

rd_plot(M1)
rd_plot(M1, linewidth = 1.1)
}
\author{
Steven V. Miller
}
