% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentiment_analysis_grasp.R
\name{sentiment_analysis_grasp}
\alias{sentiment_analysis_grasp}
\title{Sentiment Analysis using Grasp}
\usage{
sentiment_analysis_grasp(documents, sentences, language, grasp_folder)
}
\arguments{
\item{documents}{A character vector of document identifiers for which sentiment analysis needs to be performed.}

\item{sentences}{A data frame containing sentence-level data. This should include columns like \code{sentenceid}, \code{sentence}, \code{document}, \code{submissionid}, \code{competencyid}, and \code{type} (which indicates the type of feedback).}

\item{language}{A string indicating the language of the sentences to analyze. Supported languages include "nl" (Dutch), "de" (German), and "fr" (French).}

\item{grasp_folder}{The folder path where the Grasp Python module is located. This is required to run the Grasp sentiment analysis.}
}
\value{
A data table with the following columns:
\itemize{
\item \code{sentenceid}: The ID of the sentence.
\item \code{sentence}: The sentence being analyzed.
\item \code{polarity}: The sentiment polarity score for the sentence.
\item \code{document}: The document identifier to which the sentence belongs.
}
}
\description{
This function performs sentiment analysis on a collection of sentences using the Grasp sentiment analysis model. It computes the polarity of each sentence and returns a table with sentiment scores.
}
\details{
The function loads the Grasp sentiment analysis model via \code{reticulate} and computes sentiment polarity for each sentence. It performs a special handling for Dutch language sentences that start with certain keywords to prepend "suboptimal" to improve sentiment accuracy. The sentiment is calculated using the \code{pov} function from the Grasp model. To use the sentiment setting for Dutch medical education, copy file \code{nl_pov.json}, included in this package, and paste it in grasp_folder/lm.
}
\keyword{internal}
