% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionsPlotting_circular.R
\name{superbPlot.circularpointjitter}
\alias{superbPlot.circularpointjitter}
\title{superbPlot 'circularpointjitter' layout}
\usage{
superbPlot.circularpointjitter(
  summarydata,
  xfactor,
  groupingfactor,
  addfactors,
  rawdata = NULL,
  pointParams = list(),
  jitterParams = list(),
  errorbarParams = list(),
  facetParams = list(),
  radarParams = list(),
  xAsFactor = TRUE
)
}
\arguments{
\item{summarydata}{a data.frame with columns "center", "lowerwidth" and "upperwidth" for each level of the factors;}

\item{xfactor}{a string with the name of the column where the factor going on the horizontal axis is given;}

\item{groupingfactor}{a string with the name of the column for which the data will be grouped on the plot;}

\item{addfactors}{a string with up to two additional factors to make the rows and columns panels, in the form "fact1 ~ fact2";}

\item{rawdata}{always contains "DV" for each participants and each level of the factors}

\item{pointParams}{(optional) list of graphic directives that are sent to the geom_bar layer}

\item{jitterParams}{(optional) list of graphic directives that are sent to the geom_bar layer}

\item{errorbarParams}{(optional) list of graphic directives that are sent to the geom_superberrorbar layer}

\item{facetParams}{(optional) list of graphic directives that are sent to the facet_grid layer}

\item{radarParams}{(optional)  list of arguments to the radar coordinates (seel \code{coord_radial()} ).}

\item{xAsFactor}{(optional) Boolean to indicate if the factor on the horizontal should continuous or discrete (default is discrete)}
}
\value{
a ggplot object
}
\description{
superb comes with a few circular layouts for making plots.
It produces ggplot objects that can be further customized.

It has these parameters:
}
\examples{
# This will make a plot with points
superbPlot(ToothGrowth, 
   BSFactors = c("dose","supp"), variables = "len",
   plotLayout = "circularpointjitter" 
)

# if you extract the data with superbData, you can 
# run this layout directly
#processedData <- superbData(ToothGrowth, 
# BSFactors = c("dose","supp"), variables = "len"
#)
#
#superbPlot.circularpointjitter(processedData$summaryStatistic,
#   "dose",
#   "supp",
#   ".~.",
#   processedData$rawData)

}
