% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-threshold-profile.R
\name{make_threshold_profile}
\alias{make_threshold_profile}
\title{Illustrates how network properties vary with the similarity threshold}
\usage{
make_threshold_profile(
  data,
  layer = NULL,
  comparisons = NULL,
  metric = NULL,
  count = NULL,
  limits = NULL,
  dummycode = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame corresponding to the attitudes held by agents with
respect to a number of items}

\item{layer}{A string flag specifying the type of network to be extracted,
\itemize{
\item \code{"agent"} produces the network corresponding to the agents, which we assume
to be rows in \code{data}
\item \code{"symbolic"} produces the network corresponding to the symbols, or items,
which we assume to be columns in \code{data}
}}

\item{comparisons}{An integer, minimum number of comparisons for valid distance.}

\item{metric}{A string option describing the similarity metric to be used.}

\item{count}{The number of threshold values to include in the description.}

\item{limits}{Specify the limits of the Likert range in during a data preprocessing step.}

\item{dummycode}{Specify whether to apply dummycoding during a data preprocessing step.}

\item{...}{Used to handle alternative argument spellings.}
}
\value{
A data frame containing properties of the \code{agent} or \code{symbolic} network as a
function of the similarity threshold. In particular, it contains three columns
named
\itemize{
\item \code{threshold}, the value of the similarity threshold
\item \code{ad}, the average degree resulting from \code{threshold}, and
\item \code{lcc}, the size of the largest connected component resulting from
\code{threshold}
}
}
\description{
\code{make_threshold_profile()} outputs properties of the agent or symbolic network
as a function of similarity threshold.
}
\details{
Note that this routine is expensive on large graphs. We study networks over the
full range of similarity thresholds \verb{[-1, 1]}, and as a result, produce
networks that are complete at the lower limit of that range. Note that by default we
will subsample the provided survey with the C++ implementation in order to
avoid memory issues. We could then allow a flag that turns off the subsampling
step, at the user's peril.
}
\examples{
S <- make_synthetic_data(20, 5)
}
