% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hadamard-matrix-helpers.R
\name{find_minimum_hadamard_order}
\alias{find_minimum_hadamard_order}
\title{Find the smallest Hadamard order available in the 'survey' package}
\usage{
find_minimum_hadamard_order(n)
}
\arguments{
\item{n}{A single positive integer.}
}
\value{
A single positive integer.
}
\description{
Identifies the order of the smallest Hadamard
matrix available in the 'survey' package, such that
the order is greater than or equal to \code{n}.
This is useful for identifying the minimum number of
replicates that can be constructed for replication methods
such as BRR or Fay's generalized replication method.
}
\details{
To get the Hadamard matrix of this size with the 'survey' package,
use \code{survey::hadamard(k - 1)}, where \code{k} is the
output of \code{find_minimum_hadamard_order()}.
}
\keyword{internal}
