% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swaglm_test.R
\name{swaglm_test}
\alias{swaglm_test}
\title{swaglm_test}
\usage{
swaglm_test(swag_obj, B = 50, verbose = FALSE)
}
\arguments{
\item{swag_obj}{An object of class \code{swaglm}.}

\item{B}{a \code{integer} specifying the number of swag procedures to generate a distribution of the network statistics under the null.}

\item{verbose}{A \code{boolean} used to control verbose}
}
\value{
A \code{swaglm_test} object.
}
\description{
Compute significance of identified set of variables
}
\examples{
n <- 2000
p <- 50

# create design matrix and vector of coefficients
Sigma <- diag(rep(1/p, p))
X <- MASS::mvrnorm(n = n, mu = rep(0, p), Sigma = Sigma)
beta = c(-15,-10,5,10,15, rep(0,p-5))
z <- 1 + X\%*\%beta
pr <- 1/(1 + exp(-z))
y <- as.factor(rbinom(n, 1, pr))
y = as.numeric(y)-1
quantile_alpha = .15
p_max = 20
swag_obj = swaglm::swaglm(X=X, y = y, p_max = p_max, family = stats::binomial(),
                          alpha = quantile_alpha, verbose = TRUE, seed = 123)
swaglm::swaglm_test(swag_obj, B = 10, verbose = TRUE)
}
