% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_tci}
\alias{simulate_tci}
\title{Simulate open- or closed-loop control}
\usage{
simulate_tci(
  pkmod_prior,
  pkmod_true,
  target_vals,
  target_tms,
  obs_tms,
  update_tms = NULL,
  type = c("effect", "plasma"),
  custom_alg = NULL,
  resp_bounds = NULL,
  delay = 0,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{pkmod_prior}{`pkmod` or `poppkmod` object describing a PK/PK-PD model that is used to calculate
TCI infusion rates and is updated as data are simulated and incorporated. Must have an
associated Omega matrix.}

\item{pkmod_true}{`pkmod` or `poppkmod` object describing the patient's "true" response. This model
will be used to simulate observations.}

\item{target_vals}{A vector of numeric values indicating PK or PD targets for TCI algorithm.}

\item{target_tms}{A vector of numeric values indicating times at which the TCI algorithm should
begin targeting each value.}

\item{obs_tms}{Times at which data values should be simulated from `pkmod_true`.}

\item{update_tms}{Times at which `pkmod_prior` should be updated using all available
simulated observations.}

\item{type}{Type of TCI algorithm to be used. Options are "plasma" and "effect".
Defaults to "effect". Will be overwritten if `custom_alg` is non-null.}

\item{custom_alg}{Custom TCI algorithm to overwrite default plasma- or effect-site targeting.}

\item{resp_bounds}{Optional vector of two values indicating minimum and maximum values possible for the response.}

\item{delay}{Optional numeric value indicating a temporal delay between when observations
are simulated and when they should be made available for updating `pkmod_prior`. For example,
a delay should be set to account for a processing time delay in Bispectral Index measurements
or the time required to measure drug concentrations from collected samples.}

\item{seed}{An integer used to initialize the random number generator.}

\item{verbose}{Logical. Print progress as simulation is run.}
}
\description{
Simulate responses from a `pkmod` or `poppkmod` object using TCI control.
Infusion rates are calculated to reach targets using `pkmod_prior`. Data values
are simulated using `pkmod_true`. `pkmod_prior` and `pkmod_true` do not need to
have the same parameters or structure and should be different when simulating
responses under model misspecification.
If update times (argument `update_tms`) are provided then the function `simulate_clc`
is called for "closed-loop" control and model parameters will be updated via
Bayes' rule using available data. Only parameters with values in the Omega matrix
will be updated. A data processing delay can be added through the argument `delay`.
See ?bayes_update? for more details. If update times are not specified, then
the function `simulate_olc` will be called to implement "open-loop" control
and model parameters will not be updated. Simulation results have class `tci_sim`
and can be plotted using `plot.tci_sim()`.
}
\examples{
data <- data.frame(ID = 1:3, AGE = c(20,30,40), TBW = c(60,70,80),
HGT = c(150,160,170), MALE = c(TRUE,FALSE,TRUE))
pkmod_prior <- poppkmod(data, drug = "ppf", model = "eleveld")
pkmod_true  <- poppkmod(data, drug = "ppf", model = "eleveld", sample = TRUE)
obs_tms <- seq(1/6,10,1/6)
target_vals = c(75,60,50,50)
target_tms = c(0,3,6,10)

# open-loop simulation (without updates)
sim_ol <- simulate_tci(pkmod_prior, pkmod_true, target_vals, target_tms, obs_tms,
seed = 200)
plot(sim_ol)

# closed-loop simulation (with updates)
\dontrun{
sim_cl <- simulate_tci(pkmod_prior, pkmod_true, target_vals, target_tms, obs_tms,
update_tms = c(2,4,6,8), seed = 200)
plot(sim_cl, wrap_id = TRUE, show_inf = TRUE, show_data = TRUE)
}
}
