app_driver_tm_g_distribution <- function() {
  data <- teal.data::teal_data()
  data <- within(data, ADSL <- teal.data::rADSL)
  teal.data::join_keys(data) <- teal.data::default_cdisc_join_keys[names(data)]

  vars1 <- teal.transform::choices_selected(
    teal.transform::variable_choices(data[["ADSL"]], c("ARM", "COUNTRY", "SEX")),
    selected = NULL
  )

  init_teal_app_driver(
    data = data,
    modules = tm_g_distribution(
      dist_var = teal.transform::data_extract_spec(
        dataname = "ADSL",
        select = teal.transform::select_spec(
          choices = teal.transform::variable_choices(data[["ADSL"]], c("AGE", "BMRKR1")),
          selected = "BMRKR1",
          multiple = FALSE,
          fixed = FALSE
        )
      ),
      strata_var = teal.transform::data_extract_spec(
        dataname = "ADSL",
        filter = teal.transform::filter_spec(
          vars = vars1,
          multiple = TRUE
        )
      ),
      group_var = teal.transform::data_extract_spec(
        dataname = "ADSL",
        filter = teal.transform::filter_spec(
          vars = vars1,
          multiple = TRUE
        )
      ),
      ggplot2_args = teal.widgets::ggplot2_args(
        labs = list(subtitle = "Plot generated by Distribution Module")
      ),
      ggtheme = "classic",
      freq = TRUE,
      bins = 36,
    )
  )
}

testthat::test_that("e2e - tm_g_distribution: Module is initialised with the specified defaults.", {
  testthat::skip("chromium")
  skip_if_too_deep(5)

  app_driver <- app_driver_tm_g_distribution()

  app_driver$expect_no_shiny_error()

  # Encodings in the Histogram tab
  testthat::expect_equal(app_driver$get_active_module_input("dist_i-dataset_ADSL_singleextract-select"), "BMRKR1")
  testthat::expect_null(app_driver$get_active_module_input("group_i-dataset_ADSL_singleextract-filter1-col"))
  testthat::expect_null(app_driver$get_active_module_input("group_i-dataset_ADSL_singleextract-filter1-vals"))
  testthat::expect_null(app_driver$get_active_module_input("strata_i-dataset_ADSL_singleextract-filter1-col"))
  testthat::expect_equal(app_driver$get_active_module_input("bins"), 36)
  testthat::expect_equal(app_driver$get_active_module_input("main_type"), "Frequency")
  testthat::expect_equal(app_driver$get_active_module_input("ggtheme"), "classic")
  testthat::expect_equal(app_driver$get_active_module_input("tabs"), "Histogram")

  # Encodings in the QQplot tab
  app_driver$set_active_module_input("tabs", "QQplot")
  testthat::expect_true(app_driver$get_active_module_input("qq_line"))

  app_driver$stop()
})

testthat::test_that("e2e - tm_g_distribution: Histogram encoding inputs produce output without validation errors.", {
  testthat::skip("chromium")
  skip_if_too_deep(5)

  app_driver <- app_driver_tm_g_distribution()

  app_driver$set_active_module_input("main_type", "Density")
  app_driver$expect_no_validation_error()
  app_driver$set_active_module_input("dist_tests", "Shapiro-Wilk")

  # Encodings in the Histogram tab
  app_driver$set_active_module_input("group_i-dataset_ADSL_singleextract-filter1-col", "ARM")
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input(
    "group_i-dataset_ADSL_singleextract-filter1-vals",
    c("A: Drug X", "C: Combination")
  )
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("scales_type", "Free")
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("strata_i-dataset_ADSL_singleextract-filter1-col", "SEX")
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("strata_i-dataset_ADSL_singleextract-filter1-vals", c("F"))
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("bins", 50)
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("add_dens", FALSE)
  app_driver$expect_no_validation_error()

  app_driver$stop()
})

testthat::test_that("e2e - tm_g_distribution: QQ plot encoding inputs produce output without validation errors.", {
  testthat::skip("chromium")
  skip_if_too_deep(5)

  app_driver <- app_driver_tm_g_distribution()

  # Encodings in the QQplot tab
  app_driver$set_active_module_input("main_type", "Density")
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("tabs", "QQplot")
  app_driver$set_active_module_input("t_dist", "normal")
  app_driver$click(NS(app_driver$active_module_ns(), "params_reset"))

  app_driver$expect_no_validation_error()

  app_driver$stop()
})
