% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frmt_plans.R
\name{frmt_structure}
\alias{frmt_structure}
\title{Format Structure Object}
\usage{
frmt_structure(group_val = ".default", label_val = ".default", ...)
}
\arguments{
\item{group_val}{A string or a named list of strings which represent the
value of group should be when the given frmt is implemented}

\item{label_val}{A string which represent the value of label should be when
the given frmt is implemented}

\item{...}{either a \code{\link[=frmt]{frmt()}}, \code{\link[=frmt_combine]{frmt_combine()}}, or a \code{\link[=frmt_when]{frmt_when()}} object.
This can be named to also specify the parameter value}
}
\value{
frmt_structure object
}
\description{
Function needed to create a frmt_structure object, which is a building block
of \code{\link[=body_plan]{body_plan()}}. This specifies the rows the format will be applied to.
}
\section{Images}{

Here are some example outputs:
\if{html}{\out{
<img src="https://raw.githubusercontent.com/GSK-Biostatistics/tfrmt/main/images/tfrmt-frmts.jpg" alt = "Example comparing fmt, frmt_combine, and frmt_when" style="width:100\%;">
}}
}

\examples{

sample_structure <- frmt_structure(
          group_val = c("group1"),
          label_val = ".default",
          frmt("XXX")
        )
## multiple group columns
sample_structure <- frmt_structure(
          group_val = list(grp_col1 = "group1", grp_col2 = "subgroup3"),
          label_val = ".default",
          frmt("XXX")
        )

}
\seealso{
\code{\link[=body_plan]{body_plan()}} combines the frmt_structures to be applied to the
table body, and \code{\link[=frmt]{frmt()}}, \code{\link[=frmt_combine]{frmt_combine()}}, and \code{\link[=frmt_when]{frmt_when()}} define the
format semantics.

\href{https://gsk-biostatistics.github.io/tfrmt/articles/body_plan.html}{Link to related article}
}
