% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{rotate_pca}
\alias{rotate_pca}
\title{Rotate factors to match Principal-Components Analysis}
\usage{
rotate_pca(
  L_tf,
  x_sf = matrix(0, nrow = 0, ncol = ncol(L_tf)),
  order = c("none", "increasing", "decreasing")
)
}
\arguments{
\item{L_tf}{Loadings matrix with dimension \eqn{T \times F}.}

\item{x_sf}{Spatial response with dimensions \eqn{S \times F}.}

\item{order}{Options for resolving label-switching via reflecting
each factor to achieve a given order across dimension \eqn{T}.}
}
\value{
List containing the rotated loadings \code{L_tf},
the inverse-rotated response matrix \code{x_sf},
and the rotation \code{H}
}
\description{
Rotate lower-triangle loadings matrix
to order factors from largest to smallest variance.
}
