% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_latex.R
\name{theme_latex}
\alias{theme_latex}
\title{LaTeX-Specific Theme for \code{tinytable}}
\usage{
theme_latex(
  x,
  inner = NULL,
  outer = NULL,
  environment = get_option("tinytable_latex_environment", default = NULL),
  environment_table = get_option("tinytable_latex_environment_table", default = TRUE),
  multipage = get_option("tinytable_latex_multipage", default = FALSE),
  rowhead = get_option("tinytable_latex_rowhead", 0L),
  rowfoot = get_option("tinytable_latex_rowfoot", 0L),
  resize_width = get_option("tinytable_latex_resize_width", 1),
  resize_direction = get_option("tinytable_latex_resize_direction", default = NULL),
  placement = get_option("tinytable_latex_placement", NULL),
  preamble = NULL,
  engine = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{tinytable} object to apply LaTeX theming to.}

\item{inner}{Character string specifying inner tabularray options. These options
control the internal formatting of the table (e.g., column alignment, spacing).
Will be added to any existing inner options. Default is \code{NULL}.}

\item{outer}{Character string specifying outer tabularray options. These options
control the external formatting around the table. Will be added to any existing
outer options. Default is \code{NULL}.}

\item{environment}{Character string specifying the LaTeX table environment to use.
Options are:
\itemize{
\item \code{"tblr"} - Standard tabularray table (default)
\item \code{"talltblr"} - Tall tabularray table for tables that may break across pages
\item \code{"longtblr"} - Long tabularray table for multi-page tables
\item \code{"tabular"} - Basic LaTeX tabular environment without tabularray features
}

Default is controlled by \code{tinytable_latex_environment} option.}

\item{environment_table}{Logical indicating whether to wrap the table in a \code{table}
environment. When \code{FALSE}, only the core table structure is output without the
surrounding table wrapper. Automatically set to \code{FALSE} when \code{environment = "longtblr"}.
Default is controlled by \code{tinytable_latex_environment_table} option.}

\item{multipage}{Logical indicating whether to enable multipage table functionality.
When \code{TRUE}, automatically switches to \code{longtblr} environment and sets appropriate
options for tables that span multiple pages. Default is controlled by
\code{tinytable_latex_multipage} option.}

\item{rowhead}{Integer specifying the number of header rows to repeat on each page
in multipage tables. Only valid with \code{longtblr} environment. Default is controlled
by \code{tinytable_latex_rowhead} option.}

\item{rowfoot}{Integer specifying the number of footer rows to repeat on each page
in multipage tables. Only valid with \code{longtblr} environment. Default is controlled
by \code{tinytable_latex_rowfoot} option.}

\item{resize_width}{Numeric value between 0.01 and 1.0 specifying the target width
as a fraction of \verb{\\\\linewidth} when resizing tables. Only used when \code{resize_direction}
is specified. Default is controlled by \code{tinytable_latex_resize_width} option.}

\item{resize_direction}{Character string specifying how to resize tables that are
too wide or too narrow. Options are:
\itemize{
\item \code{"down"} - Only shrink tables wider than \verb{\\\\linewidth}
\item \code{"up"} - Only expand tables narrower than \verb{\\\\linewidth}
\item \code{"both"} - Resize all tables to exactly \verb{resize_width * \\\\linewidth}
}

Default is controlled by \code{tinytable_latex_resize_direction} option.}

\item{placement}{Character string specifying LaTeX float placement options for the
table environment (e.g., "h", "t", "b", "p", "H"). Only used when \code{environment_table = TRUE}.
Default is controlled by \code{tinytable_latex_placement} option.}

\item{preamble}{Logical value specifying whether to include LaTeX preamble packages.
If not NULL, overrides the table's preamble setting.}

\item{engine}{Character string specifying the LaTeX engine to use for PDF compilation.
Options are "xelatex", "pdflatex", or "lualatex". If not NULL, overrides the table's engine setting.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A modified \code{tinytable} object with LaTeX-specific theming applied.
}
\description{
This function provides comprehensive LaTeX-specific theming and configuration options
for \code{tinytable} objects. It allows customization of LaTeX environments, table layout,
multipage behavior, resizing, and placement within LaTeX documents.
}
\details{
The function provides fine-grained control over LaTeX table output through several mechanisms:

\strong{Environment Selection:}
Different LaTeX environments offer different capabilities:
\itemize{
\item \code{tblr}: Modern tabularray syntax with full styling support
\item \code{talltblr}: Like \code{tblr} but optimized for tall tables
\item \code{longtblr}: Supports page breaks and repeated headers/footers
\item \code{tabular}: Basic LaTeX syntax, limited styling but maximum compatibility
}

\strong{Multipage Tables:}
When \code{multipage = TRUE} or when \code{rowhead}/\code{rowfoot} are specified, the function
automatically switches to \code{longtblr} environment and disables the table wrapper.
This allows tables to break across pages while maintaining headers and footers.

\strong{Resizing:}
The resize functionality uses LaTeX's \verb{\\\\resizebox} command to automatically
adjust table width based on content and page constraints. This is particularly
useful for tables with many columns.

\strong{Tabularray Options:}
Inner and outer options directly control tabularray formatting. Inner options
affect cell content and spacing, while outer options control the table's
relationship with surrounding text.
}
\seealso{
\code{\link[=tt]{tt()}}, \code{\link[=style_tt]{style_tt()}}, \code{\link[=save_tt]{save_tt()}}
}
