% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_plot_order.R
\name{tm_plot_order}
\alias{tm_plot_order}
\title{Determine plotting order of features}
\usage{
tm_plot_order(
  aes,
  reverse = TRUE,
  na.order = c("mix", "bottom", "top"),
  null.order = c("bottom", "mix", "top"),
  null.below.na = TRUE
)
}
\arguments{
\item{aes}{Visual variable for which the values determine the plotting order.
Example: bubble map where the \code{"size"} aesthetic is used.
A data variable (say population) is mapped via a continuous scale (\code{\link[=tm_scale_continuous]{tm_scale_continuous()}})
to bubble sizes. The bubbles are plotted in order of size.
How is determined by the other arguments. Use \code{"DATA"} to keep the same
order as in the data. Another special value are \code{"AREA"} and \code{"LENGTH"}
which are preserved for polygons and lines respectively: rather than a data
variable the polygon area / line lengths determines the plotting order.}

\item{reverse}{Logical that determines whether the visual values are plotted
in reversed order. The visual values (specified with tmap option \code{"values.var"})
are by default reversed, so plotted starting from the last value.
In the bubble map example, this means that large bubbles are plotted first,
hence at the bottom.}

\item{na.order}{Where should features be plotted that have an \code{NA} value for
(at least) one other aesthetic variable? In the (order) \code{"mix"}, at the \code{"bottom"},
or on \code{"top"}? In the bubble map example: if fill color is missing for some bubble,
where should those bubbles be plotted?}

\item{null.order}{Where should non-selected (aka null) features be plotted?}

\item{null.below.na}{Should null features be plotted below NA features?}
}
\description{
Determine plotting order of features.
}
