% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-oxfordiiitpet.R
\name{oxfordiiitpet_dataset}
\alias{oxfordiiitpet_dataset}
\alias{oxfordiiitpet_binary_dataset}
\title{Oxford-IIIT Pet Classification Datasets}
\usage{
oxfordiiitpet_dataset(
  root = tempdir(),
  train = TRUE,
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)

oxfordiiitpet_binary_dataset(
  root = tempdir(),
  train = TRUE,
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)
}
\arguments{
\item{root}{Character. Root directory where the dataset is stored or will be downloaded to. Files are placed under \code{root/oxfordiiitpet}.}

\item{train}{Logical. If TRUE, use the training set; otherwise, use the test set. Not applicable to all datasets.}

\item{transform}{Optional. A function that takes an image and returns a transformed version (e.g., normalization, cropping).}

\item{target_transform}{Optional. A function that transforms the label.}

\item{download}{Logical. If TRUE, downloads the dataset to \verb{root/}. If the dataset is already present, download is skipped.}
}
\value{
A torch dataset object \code{oxfordiiitpet_dataset} or \code{oxfordiiitpet_binary_dataset}.
Each element is a named list with:
\itemize{
\item \code{x}: A H x W x 3 integer array representing an RGB image.
\item \code{y}: An integer label:
\itemize{
\item For \code{oxfordiiitpet_dataset}: a value from 1–37 representing the breed.
\item For \code{oxfordiiitpet_binary_dataset}: 1 for Cat, 2 for Dog.
}
}
}
\description{
Oxford-IIIT Pet Datasets
}
\details{
The Oxford-IIIT Pet collection is a \strong{classification} dataset consisting of high-quality
images of 37 cat and dog breeds. It includes two variants:
\itemize{
\item \code{oxfordiiitpet_dataset}: Multi-class classification across 37 pet breeds.
\item \code{oxfordiiitpet_binary_dataset}: Binary classification distinguishing cats vs dogs.
}

The Oxford-IIIT Pet dataset contains over 7,000 images across 37 categories,
with roughly 200 images per class. Each image is labeled with its breed and species (cat/dog).
}
\examples{
\dontrun{
# Multi-class version
oxford <- oxfordiiitpet_dataset(download = TRUE)
first_item <- oxford[1]
first_item$x  # RGB image
first_item$y  # Label in 1–37
oxford$classes[first_item$y]  # Breed name

# Binary version
oxford_bin <- oxfordiiitpet_binary_dataset(download = TRUE)
first_item <- oxford_bin[1]
first_item$x  # RGB image
first_item$y  # 1 for Cat, 2 for Dog
oxford_bin$classes[first_item$y]  # "Cat" or "Dog"
}

}
\seealso{
Other classification_dataset: 
\code{\link{caltech_dataset}},
\code{\link{cifar10_dataset}()},
\code{\link{eurosat_dataset}()},
\code{\link{fer_dataset}()},
\code{\link{fgvc_aircraft_dataset}()},
\code{\link{flowers102_dataset}()},
\code{\link{image_folder_dataset}()},
\code{\link{lfw_dataset}},
\code{\link{mnist_dataset}()},
\code{\link{places365_dataset}()},
\code{\link{tiny_imagenet_dataset}()},
\code{\link{whoi_plankton_dataset}()},
\code{\link{whoi_small_coralnet_dataset}()}
}
\concept{classification_dataset}
