% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_smooth.R
\name{ts_fil_smooth}
\alias{ts_fil_smooth}
\title{Time Series Smooth}
\usage{
ts_fil_smooth()
}
\value{
A \code{ts_fil_smooth} object.
}
\description{
Remove or reduce randomness (noise) using a robust smoothing
strategy that first mitigates outliers and then smooths residual variation.
}
\examples{
# Robust smoothing with iterative outlier mitigation
# Load package and example data
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2 * tsd$y[9]  # inject an outlier

# Fit smoother and transform to reduce spikes/noise
filter <- ts_fil_smooth()
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# Compare original vs smoothed series
plot_ts_pred(y = tsd$y, yadj = y)
}
