% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmle_txshift.R
\name{fit_fluctuation}
\alias{fit_fluctuation}
\title{Fit One-Dimensional Fluctuation Model for Updating Initial Estimates}
\usage{
fit_fluctuation(
  Y,
  Qn_scaled,
  Hn,
  ipc_weights = rep(1, length(Y)),
  method = c("standard", "weighted"),
  flucmod_tol = 50
)
}
\arguments{
\item{Y}{A \code{numeric} vector corresponding to an outcome variable.}

\item{Qn_scaled}{An object providing the value of the outcome evaluate
after inducing a shift in the exposure. This object should be passed in
after being constructed by a call to \code{\link{est_Q}}.}

\item{Hn}{An object providing values of the auxiliary ("clever") covariate,
constructed from the treatment mechanism and required for targeted minimum
loss estimation. This object object should be passed in after being
constructed by a call to \code{\link{est_Hn}}.}

\item{ipc_weights}{A \code{numeric} vector that gives inverse probability of
censoring weights for each observation. These are generated by invoking the
routines for estimating the censoring mechanism.}

\item{method}{A \code{character} giving the type of regression to be used in
traversing the fluctuation sub-model. The available choices are "weighted"
and "standard". Consult the literature for details on the differences.}

\item{flucmod_tol}{A \code{numeric} indicating the largest value to be
tolerated in the fluctuation model for the targeted minimum loss estimator.}
}
\value{
A \code{list} containing the fluctuation model (a \code{glm} object)
 produced by logistic regression, a \code{character} vector indicating the
 type of fluctuation (whether the auxiliary covariates was used as a weight
 or included directly in the model formula), the updated estimates of the
 outcome regression under the shifted value of the exposure, and the updated
 estimates of the outcome regression under the natural value of exposure.
}
\description{
Fit One-Dimensional Fluctuation Model for Updating Initial Estimates
}
\details{
Procedure for fitting a one-dimensional fluctuation model to update
 the initial estimates of the outcome regression based on the auxiliary
 covariate. These updated estimates are subsequently used to construct the
 TML estimator of the counterfactual mean under a modified treatment policy.
}
